/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.compiler;

import com.taobao.arthas.compiler.CustomJavaFileObject;
import com.taobao.arthas.compiler.DynamicClassLoader;
import com.taobao.arthas.compiler.MemoryByteCode;
import com.taobao.arthas.compiler.PackageInternalsFinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class DynamicJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private static final String[] superLocationNames = new String[]{StandardLocation.PLATFORM_CLASS_PATH.name(), "SYSTEM_MODULES"};
    private final PackageInternalsFinder finder;
    private final DynamicClassLoader classLoader;
    private final List<MemoryByteCode> byteCodes = new ArrayList<MemoryByteCode>();

    public DynamicJavaFileManager(JavaFileManager fileManager, DynamicClassLoader classLoader) {
        super(fileManager);
        this.classLoader = classLoader;
        this.finder = new PackageInternalsFinder(classLoader);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        for (MemoryByteCode byteCode : this.byteCodes) {
            if (!byteCode.getClassName().equals(className)) continue;
            return byteCode;
        }
        MemoryByteCode innerClass = new MemoryByteCode(className);
        this.byteCodes.add(innerClass);
        this.classLoader.registerCompiledSource(innerClass);
        return innerClass;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof CustomJavaFileObject) {
            return ((CustomJavaFileObject)file).getClassName();
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (location instanceof StandardLocation) {
            String locationName = ((StandardLocation)location).name();
            for (String name : superLocationNames) {
                if (!name.equals(locationName)) continue;
                return super.list(location, packageName, kinds, recurse);
            }
        }
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            return new IterableJoin<JavaFileObject>(super.list(location, packageName, kinds, recurse), this.finder.find(packageName));
        }
        return super.list(location, packageName, kinds, recurse);
    }

    static class IterableJoin<T>
    implements Iterable<T> {
        private final Iterable<T> first;
        private final Iterable<T> next;

        public IterableJoin(Iterable<T> first, Iterable<T> next) {
            this.first = first;
            this.next = next;
        }

        @Override
        public Iterator<T> iterator() {
            return new IteratorJoin<T>(this.first.iterator(), this.next.iterator());
        }
    }

    static class IteratorJoin<T>
    implements Iterator<T> {
        private final Iterator<T> first;
        private final Iterator<T> next;

        public IteratorJoin(Iterator<T> first, Iterator<T> next) {
            this.first = first;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.first.hasNext() || this.next.hasNext();
        }

        @Override
        public T next() {
            if (this.first.hasNext()) {
                return this.first.next();
            }
            return this.next.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

