/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class DynamicCompilerException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private List<Diagnostic<? extends JavaFileObject>> diagnostics;

    public DynamicCompilerException(String message, List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        super(message);
        this.diagnostics = diagnostics;
    }

    public DynamicCompilerException(Throwable cause) {
        super(cause);
    }

    private List<Map<String, Object>> getErrorList() {
        ArrayList<Map<String, Object>> messages = new ArrayList<Map<String, Object>>();
        if (this.diagnostics != null) {
            for (Diagnostic<? extends JavaFileObject> diagnostic : this.diagnostics) {
                HashMap<String, Object> message = new HashMap<String, Object>();
                message.put("line", diagnostic.getLineNumber());
                message.put("message", diagnostic.getMessage(Locale.US));
                messages.add(message);
            }
        }
        return messages;
    }

    private String getErrors() {
        StringBuilder errors = new StringBuilder();
        for (Map<String, Object> entry : this.getErrorList()) {
            for (String key : entry.keySet()) {
                Object value = entry.get(key);
                if (value != null && !value.toString().isEmpty()) {
                    errors.append(key);
                    errors.append(": ");
                    errors.append(value);
                }
                errors.append(" , ");
            }
            errors.append("\n");
        }
        return errors.toString();
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "\n" + this.getErrors();
    }
}

