/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.preferencex;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.MergeCursor;
import android.media.MediaScannerConnection;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.MimeTypeMap;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.appcompat.R;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.preference.PreferenceDialogFragmentCompat;
import com.takisoft.preferencex.RingtonePreference;
import com.takisoft.preferencex.ringtone.R;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.concurrent.LinkedBlockingQueue;

public class RingtonePreferenceDialogFragmentCompat
extends PreferenceDialogFragmentCompat {
    private static final String TAG = "RingtonePrefDialog";
    private static final String CURSOR_DEFAULT_ID = "-2";
    private static final String CURSOR_NONE_ID = "-1";
    private int selectedIndex = -1;
    private Cursor cursor;
    private RingtoneManager ringtoneManager;
    private Ringtone defaultRingtone;

    public static RingtonePreferenceDialogFragmentCompat newInstance(String key) {
        RingtonePreferenceDialogFragmentCompat fragment = new RingtonePreferenceDialogFragmentCompat();
        Bundle b = new Bundle(1);
        b.putString("key", key);
        fragment.setArguments(b);
        return fragment;
    }

    private RingtonePreference getRingtonePreference() {
        return (RingtonePreference)this.getPreference();
    }

    public void onPause() {
        super.onPause();
        this.stopPlaying();
    }

    private void stopPlaying() {
        if (this.defaultRingtone != null && this.defaultRingtone.isPlaying()) {
            this.defaultRingtone.stop();
        }
        if (this.ringtoneManager != null) {
            this.ringtoneManager.stopPreviousRingtone();
        }
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        super.onPrepareDialogBuilder(builder);
        RingtonePreference ringtonePreference = this.getRingtonePreference();
        this.createCursor(ringtonePreference.getRingtone());
        final Context context = this.getContext();
        int ringtoneType = ringtonePreference.getRingtoneType();
        final boolean showDefault = ringtonePreference.getShowDefault();
        final boolean showSilent = ringtonePreference.getShowSilent();
        final Uri defaultUri = showDefault ? RingtoneManager.getDefaultUri((int)ringtoneType) : null;
        String[] titles = new String[this.cursor.getCount()];
        if (this.cursor.moveToFirst()) {
            do {
                titles[this.cursor.getPosition()] = this.cursor.getString(1);
            } while (this.cursor.moveToNext());
        }
        builder.setSingleChoiceItems((ListAdapter)this.buildAdapter(context, this.cursor), this.selectedIndex, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (i < RingtonePreferenceDialogFragmentCompat.this.cursor.getCount()) {
                    RingtonePreferenceDialogFragmentCompat.this.selectedIndex = i;
                    int realIdx = i - (showDefault ? 1 : 0) - (showSilent ? 1 : 0);
                    RingtonePreferenceDialogFragmentCompat.this.stopPlaying();
                    if (showDefault && i == 0) {
                        if (RingtonePreferenceDialogFragmentCompat.this.defaultRingtone != null) {
                            RingtonePreferenceDialogFragmentCompat.this.defaultRingtone.play();
                        } else {
                            RingtonePreferenceDialogFragmentCompat.this.defaultRingtone = RingtoneManager.getRingtone((Context)context, (Uri)defaultUri);
                            if (RingtonePreferenceDialogFragmentCompat.this.defaultRingtone != null) {
                                RingtonePreferenceDialogFragmentCompat.this.defaultRingtone.play();
                            }
                        }
                    } else if ((showDefault && i == 1 || !showDefault && i == 0) && showSilent) {
                        RingtonePreferenceDialogFragmentCompat.this.ringtoneManager.stopPreviousRingtone();
                    } else {
                        Ringtone ringtone = RingtonePreferenceDialogFragmentCompat.this.ringtoneManager.getRingtone(realIdx);
                        ringtone.play();
                    }
                } else {
                    RingtonePreferenceDialogFragmentCompat.this.newRingtone();
                }
            }
        }).setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                if (RingtonePreferenceDialogFragmentCompat.this.defaultRingtone != null) {
                    RingtonePreferenceDialogFragmentCompat.this.defaultRingtone.stop();
                }
                RingtonePreferenceDialogFragmentCompat.this.onDismiss(dialogInterface);
            }
        }).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)this).setPositiveButton(17039370, (DialogInterface.OnClickListener)this);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog dialog = (AlertDialog)super.onCreateDialog(savedInstanceState);
        if (this.getRingtonePreference().shouldShowAdd()) {
            ListView listView = dialog.getListView();
            View addRingtoneView = LayoutInflater.from((Context)listView.getContext()).inflate(R.layout.add_ringtone_item, (ViewGroup)listView, false);
            listView.addFooterView(addRingtoneView);
        }
        return dialog;
    }

    public void onDialogClosed(boolean positiveResult) {
        Object uri;
        this.stopPlaying();
        this.defaultRingtone = null;
        RingtonePreference preference = this.getRingtonePreference();
        boolean showDefault = preference.getShowDefault();
        boolean showSilent = preference.getShowSilent();
        if (positiveResult && this.selectedIndex >= 0 && preference.callChangeListener(uri = showDefault && this.selectedIndex == 0 ? RingtoneManager.getDefaultUri((int)preference.getRingtoneType()) : ((showDefault && this.selectedIndex == 1 || !showDefault && this.selectedIndex == 0) && showSilent ? null : this.ringtoneManager.getRingtoneUri(this.selectedIndex - (showDefault ? 1 : 0) - (showSilent ? 1 : 0))))) {
            preference.setRingtone((Uri)uri);
        }
    }

    @NonNull
    private Cursor createCursor(Uri ringtoneUri) {
        RingtonePreference ringtonePreference = this.getRingtonePreference();
        this.ringtoneManager = new RingtoneManager(this.getContext());
        this.ringtoneManager.setType(ringtonePreference.getRingtoneType());
        this.ringtoneManager.setStopPreviousRingtone(true);
        Cursor ringtoneCursor = this.ringtoneManager.getCursor();
        String colId = ringtoneCursor.getColumnName(0);
        String colTitle = ringtoneCursor.getColumnName(1);
        MatrixCursor extras = new MatrixCursor(new String[]{colId, colTitle});
        int ringtoneType = ringtonePreference.getRingtoneType();
        boolean showDefault = ringtonePreference.getShowDefault();
        boolean showSilent = ringtonePreference.getShowSilent();
        if (showDefault) {
            switch (ringtoneType) {
                case 4: {
                    extras.addRow((Object[])new String[]{CURSOR_DEFAULT_ID, this.getString(R.string.alarm_sound_default)});
                    break;
                }
                case 2: {
                    extras.addRow((Object[])new String[]{CURSOR_DEFAULT_ID, this.getString(R.string.notification_sound_default)});
                    break;
                }
                default: {
                    extras.addRow((Object[])new String[]{CURSOR_DEFAULT_ID, this.getString(R.string.ringtone_default)});
                }
            }
        }
        if (showSilent) {
            extras.addRow((Object[])new String[]{CURSOR_NONE_ID, this.getString(R.string.ringtone_silent)});
        }
        this.selectedIndex = this.ringtoneManager.getRingtonePosition(ringtoneUri);
        if (this.selectedIndex >= 0) {
            this.selectedIndex += (showDefault ? 1 : 0) + (showSilent ? 1 : 0);
        }
        if (this.selectedIndex < 0 && showDefault && RingtoneManager.getDefaultType((Uri)ringtoneUri) != -1) {
            this.selectedIndex = 0;
        }
        if (this.selectedIndex < 0 && showSilent) {
            this.selectedIndex = showDefault ? 1 : 0;
        }
        Cursor[] cursors = new Cursor[]{extras, ringtoneCursor};
        this.cursor = new MergeCursor(cursors);
        return this.cursor;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.getRingtonePreference().getCustomRingtoneRequestCode()) {
            if (resultCode == -1) {
                Uri fileUri = data.getData();
                final Context context = this.getContext();
                RingtonePreference ringtonePreference = this.getRingtonePreference();
                final int ringtoneType = ringtonePreference.getRingtoneType();
                AsyncTask<Uri, Void, Cursor> installTask = new AsyncTask<Uri, Void, Cursor>(){

                    protected Cursor doInBackground(Uri ... params) {
                        try {
                            Uri newUri = RingtonePreferenceDialogFragmentCompat.addCustomExternalRingtone(context, params[0], ringtoneType);
                            return RingtonePreferenceDialogFragmentCompat.this.createCursor(newUri);
                        }
                        catch (IOException | IllegalArgumentException e) {
                            Log.e((String)RingtonePreferenceDialogFragmentCompat.TAG, (String)"Unable to add new ringtone: ", (Throwable)e);
                            return null;
                        }
                    }

                    protected void onPostExecute(Cursor newCursor) {
                        if (newCursor != null) {
                            ListView listView = ((AlertDialog)RingtonePreferenceDialogFragmentCompat.this.getDialog()).getListView();
                            listView.setAdapter((ListAdapter)RingtonePreferenceDialogFragmentCompat.this.buildAdapter(context, newCursor));
                            listView.setItemChecked(RingtonePreferenceDialogFragmentCompat.this.selectedIndex, true);
                            listView.setSelection(RingtonePreferenceDialogFragmentCompat.this.selectedIndex);
                            listView.clearFocus();
                        } else {
                            Toast.makeText((Context)context, (CharSequence)RingtonePreferenceDialogFragmentCompat.this.getString(R.string.unable_to_add_ringtone), (int)0).show();
                        }
                    }
                };
                installTask.execute((Object[])new Uri[]{fileUri});
            } else {
                ListView listView = ((AlertDialog)this.getDialog()).getListView();
                listView.setItemChecked(this.selectedIndex, true);
            }
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == this.getRingtonePreference().getPermissionRequestCode() && grantResults[0] == 0) {
            this.newRingtone();
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    private void newRingtone() {
        boolean hasPerm;
        boolean bl = hasPerm = ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
        if (hasPerm) {
            Intent chooseFile = new Intent("android.intent.action.GET_CONTENT");
            chooseFile.setType("audio/*");
            if (Build.VERSION.SDK_INT >= 19) {
                chooseFile.putExtra("android.intent.extra.MIME_TYPES", new String[]{"audio/*", "application/ogg"});
            }
            this.startActivityForResult(chooseFile, this.getRingtonePreference().getCustomRingtoneRequestCode());
        } else {
            this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, this.getRingtonePreference().getPermissionRequestCode());
        }
    }

    @WorkerThread
    public static Uri addCustomExternalRingtone(Context context, @NonNull Uri fileUri, int type) throws IOException {
        String mimeType;
        if (!Environment.getExternalStorageState().equals("mounted")) {
            throw new IOException("External storage is not mounted. Unable to install ringtones.");
        }
        if ("file".equals(fileUri.getScheme())) {
            fileUri = Uri.fromFile((File)new File(fileUri.getPath()));
        }
        if ((mimeType = context.getContentResolver().getType(fileUri)) == null) {
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)fileUri.toString());
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension.toLowerCase());
        }
        if (mimeType == null || !mimeType.startsWith("audio/") && !mimeType.equals("application/ogg")) {
            throw new IllegalArgumentException("Ringtone file must have MIME type \"audio/*\". Given file has MIME type \"" + mimeType + "\"");
        }
        String subdirectory = RingtonePreferenceDialogFragmentCompat.getDirForType(type);
        File outFile = RingtonePreferenceDialogFragmentCompat.getUniqueExternalFile(context, subdirectory, RingtonePreferenceDialogFragmentCompat.getFileDisplayNameFromUri(context, fileUri), mimeType);
        if (outFile != null) {
            InputStream input = context.getContentResolver().openInputStream(fileUri);
            FileOutputStream output = new FileOutputStream(outFile);
            if (input != null) {
                int len;
                byte[] buffer = new byte[10240];
                while ((len = input.read(buffer)) != -1) {
                    ((OutputStream)output).write(buffer, 0, len);
                }
                input.close();
            }
            ((OutputStream)output).close();
            try (NewRingtoneScanner scanner = null;){
                scanner = new NewRingtoneScanner(context, outFile);
                Uri len = scanner.take();
                return len;
            }
        }
        return null;
    }

    private static String getDirForType(int type) {
        switch (type) {
            case 1: 
            case 7: {
                return Environment.DIRECTORY_RINGTONES;
            }
            case 2: {
                return Environment.DIRECTORY_NOTIFICATIONS;
            }
            case 4: {
                return Environment.DIRECTORY_ALARMS;
            }
        }
        throw new IllegalArgumentException("Unsupported ringtone type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileDisplayNameFromUri(Context context, Uri uri) {
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            return uri.getLastPathSegment();
        }
        if ("content".equals(scheme)) {
            String[] projection = new String[]{"_display_name"};
            try (Cursor cursor = null;){
                cursor = context.getContentResolver().query(uri, projection, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    String string2 = cursor.getString(cursor.getColumnIndex("_display_name"));
                    return string2;
                }
            }
        }
        return uri.toString();
    }

    @Nullable
    private static File getUniqueExternalFile(Context context, String subdirectory, String fileName, String mimeType) {
        File externalStorage = Environment.getExternalStoragePublicDirectory((String)subdirectory);
        externalStorage.mkdirs();
        return RingtonePreferenceDialogFragmentCompat.buildUniqueFile(externalStorage, mimeType, fileName);
    }

    @NonNull
    private static File buildUniqueFile(File externalStorage, String mimeType, String fileName) {
        String[] parts = RingtonePreferenceDialogFragmentCompat.splitFileName(mimeType, fileName);
        String name = parts[0];
        String ext = parts[1] != null ? "." + parts[1] : "";
        File file = new File(externalStorage, name + ext);
        SecureRandom random = new SecureRandom();
        int n = 0;
        while (file.exists()) {
            if (n++ >= 32) {
                n = random.nextInt();
            }
            file = new File(externalStorage, name + " (" + n + ")" + ext);
        }
        return file;
    }

    @NonNull
    public static String[] splitFileName(String mimeType, String displayName) {
        String mimeTypeFromExt;
        String ext;
        String name;
        int lastDot = displayName.lastIndexOf(46);
        if (lastDot >= 0) {
            name = displayName.substring(0, lastDot);
            ext = displayName.substring(lastDot + 1);
            mimeTypeFromExt = MimeTypeMap.getSingleton().getMimeTypeFromExtension(ext.toLowerCase());
        } else {
            name = displayName;
            ext = null;
            mimeTypeFromExt = null;
        }
        if (mimeTypeFromExt == null) {
            mimeTypeFromExt = "application/octet-stream";
        }
        String extFromMimeType = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
        if (!TextUtils.equals((CharSequence)mimeType, (CharSequence)mimeTypeFromExt) && !TextUtils.equals((CharSequence)ext, (CharSequence)extFromMimeType)) {
            name = displayName;
            ext = extFromMimeType;
        }
        if (ext == null) {
            ext = "";
        }
        return new String[]{name, ext};
    }

    private CheckedItemAdapter buildAdapter(Context context, Cursor cursor) {
        CharSequence[] titles = new String[cursor.getCount()];
        if (cursor.moveToFirst()) {
            do {
                titles[cursor.getPosition()] = cursor.getString(1);
            } while (cursor.moveToNext());
        }
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.AlertDialog, R.attr.alertDialogStyle, 0);
        int layout2 = a.getResourceId(R.styleable.AlertDialog_singleChoiceItemLayout, 0);
        a.recycle();
        return new CheckedItemAdapter(context, layout2, 16908308, titles);
    }

    private static class CheckedItemAdapter
    extends ArrayAdapter<CharSequence> {
        public CheckedItemAdapter(Context context, int resource, int textViewResourceId, CharSequence[] objects) {
            super(context, resource, textViewResourceId, (Object[])objects);
        }

        public boolean hasStableIds() {
            return true;
        }

        public long getItemId(int position) {
            return position;
        }
    }

    private static class NewRingtoneScanner
    implements Closeable,
    MediaScannerConnection.MediaScannerConnectionClient {
        private MediaScannerConnection mMediaScannerConnection;
        private File mFile;
        private LinkedBlockingQueue<Uri> mQueue = new LinkedBlockingQueue(1);

        private NewRingtoneScanner(Context context, File file) {
            this.mFile = file;
            this.mMediaScannerConnection = new MediaScannerConnection(context, (MediaScannerConnection.MediaScannerConnectionClient)this);
            this.mMediaScannerConnection.connect();
        }

        @Override
        public void close() {
            this.mMediaScannerConnection.disconnect();
        }

        public void onMediaScannerConnected() {
            this.mMediaScannerConnection.scanFile(this.mFile.getAbsolutePath(), null);
        }

        public void onScanCompleted(String path, Uri uri) {
            if (uri == null) {
                this.mFile.delete();
                return;
            }
            try {
                this.mQueue.put(uri);
            }
            catch (InterruptedException e) {
                Log.e((String)RingtonePreferenceDialogFragmentCompat.TAG, (String)"Unable to put new ringtone Uri in queue", (Throwable)e);
            }
        }

        private Uri take() throws InterruptedException {
            return this.mQueue.take();
        }
    }
}

