/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.wheel.Key;
import com.suse.salt.netapi.datatypes.Arguments;
import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.datatypes.Job;
import com.suse.salt.netapi.datatypes.ScheduledJob;
import com.suse.salt.netapi.datatypes.StartTime;
import com.suse.salt.netapi.datatypes.Token;
import com.suse.salt.netapi.datatypes.cherrypy.Stats;
import com.suse.salt.netapi.parser.Adapters;
import com.suse.salt.netapi.parser.ArgumentsAdapter;
import com.suse.salt.netapi.parser.CollectionTypeAdapterFactory;
import com.suse.salt.netapi.parser.DateAdapter;
import com.suse.salt.netapi.parser.LocalDateTimeISOAdapter;
import com.suse.salt.netapi.parser.OptionalTypeAdapterFactory;
import com.suse.salt.netapi.parser.ResultTypeAdapterFactory;
import com.suse.salt.netapi.parser.StartTimeAdapter;
import com.suse.salt.netapi.parser.StatsAdapter;
import com.suse.salt.netapi.parser.XorTypeAdapterFactory;
import com.suse.salt.netapi.parser.ZonedDateTimeISOAdapter;
import com.suse.salt.netapi.results.ResultInfoSet;
import com.suse.salt.netapi.results.Return;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JsonParser<T> {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(String.class, Adapters.STRING).registerTypeAdapter(Boolean.class, Adapters.BOOLEAN).registerTypeAdapter(Integer.class, Adapters.INTEGER).registerTypeAdapter(Long.class, Adapters.LONG).registerTypeAdapter(Double.class, Adapters.DOUBLE).registerTypeAdapter(Date.class, (Object)new DateAdapter().nullSafe()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeISOAdapter()).registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeISOAdapter()).registerTypeAdapter(StartTime.class, (Object)new StartTimeAdapter().nullSafe()).registerTypeAdapter(Stats.class, (Object)new StatsAdapter()).registerTypeAdapter(Arguments.class, (Object)new ArgumentsAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new XorTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new ResultTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new CollectionTypeAdapterFactory()).create();
    public static final JsonParser<Return<String>> STRING = new JsonParser<Return<String>>(new TypeToken<Return<String>>(){});
    public static final JsonParser<Return<List<Token>>> TOKEN = new JsonParser<Return<List<Token>>>(new TypeToken<Return<List<Token>>>(){});
    public static final JsonParser<Return<List<ScheduledJob>>> SCHEDULED_JOB = new JsonParser<Return<List<ScheduledJob>>>(new TypeToken<Return<List<ScheduledJob>>>(){});
    public static final JsonParser<Return<List<Map<String, Job>>>> JOBS = new JsonParser<Return<List<Map<String, Job>>>>(new TypeToken<Return<List<Map<String, Job>>>>(){});
    public static final JsonParser<ResultInfoSet> JOB_RESULTS = new JsonParser<ResultInfoSet>(new TypeToken<ResultInfoSet>(){});
    public static final JsonParser<Return<List<Map<String, Map<String, Object>>>>> RETMAPS = new JsonParser<Return<List<Map<String, Map<String, Object>>>>>(new TypeToken<Return<List<Map<String, Map<String, Object>>>>>(){});
    public static final JsonParser<Return<List<Map<String, Object>>>> RUN_RESULTS = new JsonParser<Return<List<Map<String, Object>>>>(new TypeToken<Return<List<Map<String, Object>>>>(){});
    public static final JsonParser<Stats> STATS = new JsonParser<Stats>(new TypeToken<Stats>(){});
    public static final JsonParser<Return<Key.Names>> KEYS = new JsonParser<Return<Key.Names>>(new TypeToken<Return<Key.Names>>(){});
    public static final JsonParser<Map<String, Object>> MAP = new JsonParser<Map<String, Object>>(new TypeToken<Map<String, Object>>(){});
    public static final JsonParser<Event> EVENTS = new JsonParser<Event>(new TypeToken<Event>(){});
    private final TypeToken<T> type;
    private final Gson gson;

    public JsonParser(TypeToken<T> type) {
        this(type, GSON);
    }

    public JsonParser(TypeToken<T> type, Gson gson) {
        this.type = type;
        this.gson = gson;
    }

    public T parse(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader streamReader = new BufferedReader(inputStreamReader);
        return (T)this.gson.fromJson((Reader)streamReader, this.type.getType());
    }

    public T parse(String jsonString) {
        return (T)this.gson.fromJson(jsonString, this.type.getType());
    }
}

