/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.suse.salt.netapi.datatypes.Event;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BeaconEvent {
    private static final Pattern PATTERN = Pattern.compile("^salt/beacon/([^/]+)/([^/]+)/(.*)$");
    private final String beacon;
    private final String minionId;
    private final String additional;
    private final Map<String, Object> data;

    public BeaconEvent(String minionId, String beacon, String additional, Map<String, Object> data) {
        this.minionId = minionId;
        this.beacon = beacon;
        this.additional = additional;
        this.data = data;
    }

    public String getBeacon() {
        return this.beacon;
    }

    public String getMinionId() {
        return this.minionId;
    }

    public String getAdditional() {
        return this.additional;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public static Optional<BeaconEvent> parse(Event event) {
        Matcher matcher = PATTERN.matcher(event.getTag());
        if (matcher.matches()) {
            BeaconEvent result = new BeaconEvent(matcher.group(1), matcher.group(2), matcher.group(3), event.getData());
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

