/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.datatypes.target;

import com.suse.salt.netapi.datatypes.target.AbstractTarget;
import com.suse.salt.netapi.datatypes.target.TargetType;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.Objects;

abstract class DictionaryTarget
extends AbstractTarget<String> {
    public static final char DEFAULT_DELIMITER = ':';
    protected final String key;
    protected final String value;
    protected final char delimiter;

    DictionaryTarget(TargetType type, String target) {
        this(type, target, ':');
    }

    DictionaryTarget(TargetType type, String target, char delimiter) {
        super(type, target);
        this.delimiter = delimiter;
        int pos = target.lastIndexOf(delimiter);
        if (pos < 1 || pos == target.length() - 1) {
            throw new InvalidParameterException();
        }
        this.key = target.substring(0, pos);
        this.value = target.substring(pos + 1);
    }

    DictionaryTarget(TargetType type, String key, String value) {
        this(type, key, value, ':');
    }

    DictionaryTarget(TargetType type, String key, String value, char delimiter) {
        super(type, key + delimiter + value);
        this.key = Objects.requireNonNull(key);
        this.value = Objects.requireNonNull(value);
        this.delimiter = delimiter;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    @Override
    public Map<String, Object> getProps() {
        Map<String, Object> props = super.getProps();
        if (this.delimiter != ':') {
            props.put("delimiter", Character.valueOf(this.getDelimiter()));
        }
        return props;
    }
}

