/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.parser;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;

public class CollectionTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor = new ConstructorConstructor(new HashMap());

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class rawType = typeToken.getRawType();
        if (!Collection.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type elementType = .Gson.Types.getCollectionElementType((Type)type, (Class)rawType);
        TypeAdapter elementTypeAdapter = gson.getAdapter(TypeToken.get((Type)elementType));
        ObjectConstructor constructor = this.constructorConstructor.get(typeToken);
        Adapter result = new Adapter(elementTypeAdapter, constructor);
        return result;
    }

    private static final class Adapter<E>
    extends TypeAdapter<Collection<E>> {
        private final TypeAdapter<E> elementTypeAdapter;
        private final ObjectConstructor<? extends Collection<E>> constructor;

        public Adapter(TypeAdapter<E> elementAdapter, ObjectConstructor<? extends Collection<E>> constructor) {
            this.constructor = constructor;
            this.elementTypeAdapter = elementAdapter;
        }

        public Collection<E> read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                throw new JsonParseException("null is not a valid value for a Collection");
            }
            Collection collection = (Collection)this.constructor.construct();
            in.beginArray();
            while (in.hasNext()) {
                Object instance = this.elementTypeAdapter.read(in);
                collection.add(instance);
            }
            in.endArray();
            return collection;
        }

        public void write(JsonWriter out, Collection<E> collection) throws IOException {
            if (collection == null) {
                throw new JsonParseException("null is not a valid value for an array");
            }
            out.beginArray();
            for (E element : collection) {
                this.elementTypeAdapter.write(out, element);
            }
            out.endArray();
        }
    }
}

