/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.parser.JsonParser;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResultEvent {
    private static final Pattern PATTERN = Pattern.compile("^salt/job/(\\d{20})/ret/([^/]+)$");
    private static final Gson GSON = JsonParser.GSON;
    private final String jid;
    private final String minionId;
    private final JsonElement data;

    public ResultEvent(String jid, String minionId, JsonElement data) {
        this.jid = jid;
        this.minionId = minionId;
        this.data = data;
    }

    public String getJid() {
        return this.jid;
    }

    public String getMinionId() {
        return this.minionId;
    }

    public Map<String, Object> getData() {
        TypeToken<Map<String, Object>> typeToken = new TypeToken<Map<String, Object>>(){};
        return this.getData(typeToken);
    }

    public <R> R getData(TypeToken<R> type) {
        return (R)GSON.fromJson(this.data, type.getType());
    }

    public <R> R getData(Class<R> type) {
        return (R)GSON.fromJson(this.data, type);
    }

    public static Optional<ResultEvent> parse(Event event) {
        Matcher matcher = PATTERN.matcher(event.getTag());
        if (matcher.matches()) {
            ResultEvent result = new ResultEvent(matcher.group(1), matcher.group(2), event.getData(JsonElement.class));
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

