/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.datatypes;

import com.suse.salt.netapi.exception.ParsingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class StartTime {
    private final String dateString;
    private final transient Date defaultTzDate;
    private final transient SimpleDateFormat startJobDateFormat = new SimpleDateFormat("yyyy, MMM dd HH:mm:ss.SSS", Locale.US);

    public StartTime(String dateString) throws ParsingException {
        try {
            this.defaultTzDate = dateString != null ? this.startJobDateFormat.parse(dateString) : null;
        }
        catch (ParseException e) {
            throw new ParsingException(e);
        }
        this.dateString = dateString;
    }

    public synchronized Date getDate(TimeZone tz) {
        if (this.dateString == null) {
            return null;
        }
        this.startJobDateFormat.setTimeZone(tz);
        try {
            return this.startJobDateFormat.parse(this.dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Internal problem with Java and timezones " + this.dateString + " @TZ: " + tz.toString());
        }
    }

    public Date getDate() {
        return this.defaultTzDate;
    }

    public String toString() {
        return this.dateString;
    }
}

