package com.surveymonkey.surveymonkeyandroidsdk.model;

import org.json.JSONException;
import org.json.JSONObject;


public class SMAnswerResponse {
    public static final String TEXT_RESPONSE = "text_response";
    public static final String ROW_ID = "row_id";
    public static final String ROW_VALUE = "row_value";
    public static final String ROW_INDEX = "row_index";
    public static final String COLUMN_ID = "column_id";
    public static final String COLUMN_VALUE = "column_value";
    public static final String COLUMN_INDEX = "column_index";
    public static final String COLUMN_DROPDOWN_CHOICE_ID = "column_dropdown_choice_id";
    public static final String COLUMN_DROPDOWN_CHOICE_VALUE = "column_dropdown_choice_value";
    public static final String COLUMN_DROPDOWN_CHOICE_INDEX = "column_dropdown_choice_index";

    private String mTextResponse;
    private String mRowID;
    private int mRowIndex;
    private String mRowValue;
    private String mColumnID;
    private int mColumnIndex;
    private String mColumnValue;
    private String mColumnDropdownID;
    private int mColumnDropdownIndex;
    private String mColumnDropdownValue;

    /**
     * The SMAnswerResponse object represents a single answer to a survey question.
     * <p>A single survey question can have multiple SMAnswerResponse objects associated with it.
     *
     * @param jsonObject The JSON representing a user's answers to a single question in the survey
     * @see SMQuestionResponse
     */
    public SMAnswerResponse(JSONObject jsonObject) {
        try {
            if (jsonObject.has(TEXT_RESPONSE)) {
                mTextResponse = jsonObject.getString(TEXT_RESPONSE);
            }
            if (jsonObject.has(ROW_ID)) {
                mRowID = jsonObject.getString(ROW_ID);
                mRowValue = jsonObject.getString(ROW_VALUE);
                mRowIndex = jsonObject.getInt(ROW_INDEX);
            }
            if (jsonObject.has(COLUMN_ID)) {
                mColumnID = jsonObject.getString(COLUMN_ID);
                mColumnValue = jsonObject.getString(COLUMN_VALUE);
                mColumnIndex = jsonObject.getInt(COLUMN_INDEX);
            }
            if (jsonObject.has(COLUMN_DROPDOWN_CHOICE_ID)) {
                mColumnDropdownID = jsonObject.getString(COLUMN_DROPDOWN_CHOICE_ID);
                mColumnDropdownValue = jsonObject.getString(COLUMN_DROPDOWN_CHOICE_VALUE);
                mColumnDropdownIndex = jsonObject.getInt(COLUMN_DROPDOWN_CHOICE_INDEX);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getTextResponse() {
        return mTextResponse;
    }

    public String getRowID() {
        return mRowID;
    }

    public int getRowIndex() {
        return mRowIndex;
    }

    public String getRowValue() {
        return mRowValue;
    }

    public String getColumnID() {
        return mColumnID;
    }

    public int getColumnIndex() {
        return mColumnIndex;
    }

    public String getColumnValue() {
        return mColumnValue;
    }

    public String getColumnDropdownID() {
        return mColumnDropdownID;
    }

    public int getColumnDropdownIndex() {
        return mColumnDropdownIndex;
    }

    public String getColumnDropdownValue() {
        return mColumnDropdownValue;
    }

    public String getDescription() {
        return "<SMAnswerResponse: " + this +"; rowValue='" + mRowValue + "'; columnValue='" + mColumnValue + "'; columnDropdownValue='" + mColumnDropdownValue + "'; textResponse='" + mTextResponse +  " >";
    }
}
