package com.surveymonkey.surveymonkeyandroidsdk.manager

import android.app.Activity
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMNetworkUtils

import com.surveymonkey.surveymonkeyandroidsdk.SMFeedbackActivity
import com.surveymonkey.surveymonkeyandroidsdk.repository.SurveyRepository
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMConstants
import org.json.JSONException
import org.json.JSONObject

 class SurveyManager(private val surveyRepository: SurveyRepository) {
    internal suspend fun getDataFromServer(collectorHash: String, vararg customVariables: JSONObject?): JSONObject? {
        return surveyRepository.getResponse(
            SMNetworkUtils.buildURL(
                collectorHash,
                if (customVariables.isNotEmpty()) customVariables[0] else null
            )
        )
    }

    internal suspend fun startSMFeedbackActivityForResult(context: Activity, requestCode: Int, collectorHash: String, vararg customVariables: JSONObject?){
        val response = getDataFromServer(collectorHash, *customVariables)
        try {
            val tempCustomVariables = if (customVariables.isNotEmpty()) customVariables[0] else null
            if (response != null) {
                val sdkData: JSONObject =
                    response.getJSONObject(SMConstants.SURVEY_STATUS)
                val mSPageHTML =
                    response.getString(SMConstants.HTML)
                if (!sdkData.getBoolean(SMConstants.COLLECTOR_CLOSED)) {
                    SMFeedbackActivity.startActivityForResult(
                        requestCode,
                        SMNetworkUtils.buildURL(collectorHash, tempCustomVariables),
                        mSPageHTML, context,
                    )
                } else {
                    //Collector is closed, so start activity with no html so we can provide an error
                    SMFeedbackActivity.startActivityForResult(
                        requestCode,
                        SMNetworkUtils.buildURL(collectorHash, tempCustomVariables),
                        null, context,
                    )
                }
            } else {
                //Collector is closed, so start activity with no html so we can provide an error
                SMFeedbackActivity.startActivityForResult(
                    requestCode,
                    SMNetworkUtils.buildURL(collectorHash, tempCustomVariables),
                    null, context,
                )
            }
        } catch (e: JSONException) {
            e.printStackTrace()
        }
    }
}