/*
 * Decompiled with CFR 0.152.
 */
package com.sunmi.peripheral.printer;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.RemoteException;
import com.sunmi.peripheral.printer.InnerPrinterCallback;
import com.sunmi.peripheral.printer.InnerPrinterException;
import com.sunmi.peripheral.printer.SunmiPrinterService;
import java.util.Locale;

public class InnerPrinterManager {
    private InnerPrinterManager() {
    }

    public static InnerPrinterManager getInstance() {
        return SingletonContainer.instance;
    }

    public boolean bindService(Context mContext, InnerPrinterCallback callback) throws InnerPrinterException {
        if (mContext == null || callback == null) {
            throw new InnerPrinterException("parameter must be not null!");
        }
        Intent intent = new Intent();
        intent.setPackage("woyou.aidlservice.jiuiv5");
        intent.setAction("woyou.aidlservice.jiuiv5.IWoyouService");
        return mContext.getApplicationContext().bindService(intent, (ServiceConnection)callback, 1);
    }

    public void unBindService(Context mContext, InnerPrinterCallback callback) throws InnerPrinterException {
        if (mContext == null || callback == null) {
            throw new InnerPrinterException("parameter must be not null!");
        }
        mContext.getApplicationContext().unbindService((ServiceConnection)callback);
    }

    public boolean hasPrinter(SunmiPrinterService sunmiPrinterService) throws InnerPrinterException {
        if (sunmiPrinterService == null) {
            throw new InnerPrinterException("printer service does not exist!");
        }
        try {
            int status = sunmiPrinterService.updatePrinterState();
            return status != 0 && status != 505;
        }
        catch (RemoteException e) {
            return Build.SERIAL.toUpperCase(Locale.ENGLISH).contains("V1");
        }
    }

    private static class SingletonContainer {
        private static InnerPrinterManager instance = new InnerPrinterManager();

        private SingletonContainer() {
        }
    }
}

