/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.wss.saml.util;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.wss.impl.MessageConstants;
/**
 *
 * @author K.Venugopal@sun.com
 */
public class WSSNamespacePrefixMapper extends NamespacePrefixMapper{
    
    /** Creates a new instance of NamespacePrefixMapper */
    public WSSNamespacePrefixMapper() {
    }
    
    public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
        if(MessageConstants.WSSE_NS.equals(namespaceUri)){
            return MessageConstants.WSSE_PREFIX;
        }
        
        if(MessageConstants.WSSE11_NS.equals(namespaceUri)){
            return MessageConstants.WSSE11_PREFIX;
        }
        if(MessageConstants.XENC_NS.equals(namespaceUri)){
            return MessageConstants.XENC_PREFIX;
        }
        if(MessageConstants.DSIG_NS.equals(namespaceUri)){
            return MessageConstants.DSIG_PREFIX;
        }
        if(MessageConstants.WSU_NS.equals(namespaceUri)){
            return MessageConstants.WSU_PREFIX;
        }
        if(MessageConstants.WSSC_NS.equals(namespaceUri)){
            return MessageConstants.WSSC_PREFIX;
        }
        if(MessageConstants.SAML_v1_1_NS.equals(namespaceUri)){
            return MessageConstants.SAML_PREFIX;
        }
        if(MessageConstants.SAML_v2_0_NS.equals(namespaceUri)){
            return MessageConstants.SAML2_PREFIX;
        }
        if("http://www.w3.org/2001/10/xml-exc-c14n#".equals(namespaceUri)){
            return "exc14n";
        }
      
        return null;
    }
    
    public String[] getPreDeclaredNamespaceUris() {
        return new String[] { };
    }

    
}
