/*
 * KeyInfoConfirmationData.java
 *
 * Created on September 20, 2006, 1:08 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.xml.wss.saml.assertion.saml20.jaxb20;

import com.sun.xml.security.core.dsig.KeyInfoType;
import com.sun.xml.wss.logging.LogDomainConstants;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.util.SAML20JAXBUtil;
import com.sun.xml.wss.saml.util.SAMLJAXBUtil;
import java.security.PublicKey;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Element;

/**
 *
 * @author root
 */
public class KeyInfoConfirmationData extends com.sun.xml.wss.saml.internal.saml20.jaxb20.KeyInfoConfirmationDataType
        implements com.sun.xml.wss.saml.KeyInfoConfirmationData {
        
    protected PublicKey keyInfoKeyValue = null;
   // public static KeyInfoType keyInfo = null;
    
    protected static final Logger log = Logger.getLogger(
            LogDomainConstants.WSS_API_DOMAIN,
            LogDomainConstants.WSS_API_DOMAIN_BUNDLE);
                
    /**
     * Constructs a KeyInfoConfirmationData element from an existing
     * XML block.
     *
     * @param KeyInfoConfirmationData a DOM Element representing the
     *        <code>KeyInfoConfirmationData</code> object.
     * @throws SAMLException
     */
    public static KeyInfoConfirmationData fromElement(org.w3c.dom.Element element)
    throws SAMLException {
        try {
            JAXBContext jc = SAML20JAXBUtil.getJAXBContext();
                    
            javax.xml.bind.Unmarshaller u = jc.createUnmarshaller();
            return (KeyInfoConfirmationData)u.unmarshal(element);
        } catch ( Exception ex) {
            throw new SAMLException(ex.getMessage());
        }
    }
    
    /**
     * Constructs an <code>SubjectConfirmationData</code> instance.
     *
     * @param confirmationMethods A set of <code>confirmationMethods</code>
     *        each of which is a URI (String) that identifies a protocol
     *        used to authenticate a <code>Subject</code>. Please refer to
     *        <code>draft-sstc-core-25</code> Section 7 for
     *        a list of URIs identifying common authentication protocols.
     * @param SubjectConfirmationDataData Additional authentication information to
     *        be used by a specific authentication protocol. Can be passed as
     *        null if there is no <code>SubjectConfirmationDataData</code> for the
     *        <code>SubjectConfirmationData</code> object.
     * @param keyInfo An XML signature element that specifies a cryptographic
     *        key held by the <code>Subject</code>.
     * @exception SAMLException if the input data is invalid or
     *            <code>confirmationMethods</code> is empty.
     */
        
    public KeyInfoConfirmationData(Element keyInfo) throws SAMLException {
        
        JAXBContext jc = null;
        javax.xml.bind.Unmarshaller u = null;
        
        
        //Unmarshal to JAXB KeyInfo Object and set it
        try {
            jc = SAMLJAXBUtil.getJAXBContext();
            u = jc.createUnmarshaller();
        } catch ( Exception ex) {
            throw new SAMLException(ex.getMessage());
        }
        
        try {
            if ( keyInfo != null) {
                this.setKeyInfo(((KeyInfoType)((JAXBElement)u.unmarshal(keyInfo)).getValue()));
            }
        } catch (Exception ex) {
            // log here
            throw new SAMLException(ex);
        }
    }
    
    public void setKeyInfo(KeyInfoType value) {
        //this.keyInfo = value;
         this.getContent().add(value);
    }
}
