/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.wss.impl.misc;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class PolicyAttributes {
    
    private boolean issuedTokens = false;
    private boolean secureConversation = false;
    private boolean reliableMessaging = false;
    private boolean supportingTokens = false;
    private boolean endorsingST = false;//endorsing supporting tokens
    private boolean signedEndorsingST = false;//Signed endorsing supporting tokens
    private boolean signedST = false;
    private boolean protectSignature = false;
    private boolean protectTokens = false;

    
    /** Creates a new instance of PolicyAttributes */
    public PolicyAttributes() {
    }
    
    public boolean isProtectTokens() {
        return protectTokens;
    }
    
    public void setProtectTokens(boolean protectTokens) {
        this.protectTokens = protectTokens;
    }
    
    public boolean isIssuedTokens() {
        return issuedTokens;
    }
    
    public void setIssuedTokens(boolean issuedTokens) {
        this.issuedTokens = issuedTokens;
    }
    
    public boolean isSecureConversation() {
        return secureConversation;
    }
    
    public void setSecureConversation(boolean secureConversation) {
        this.secureConversation = secureConversation;
    }
    
    public boolean isReliableMessaging() {
        return reliableMessaging;
    }
    
    public void setReliableMessaging(boolean reliableMessaging) {
        this.reliableMessaging = reliableMessaging;
    }
    
    public boolean isSupportingTokens() {
        return supportingTokens;
    }
    
    public void setSupportingTokens(boolean supportingTokens) {
        this.supportingTokens = supportingTokens;
    }
    
    public boolean isEndorsingST() {
        return endorsingST;
    }
    
    public void setEndorsingST(boolean endorsingST) {
        this.endorsingST = endorsingST;
    }
    
    public boolean isSignedEndorsingST() {
        return signedEndorsingST;
    }
    
    public void setSignedEndorsingST(boolean signedEndorsingST) {
        this.signedEndorsingST = signedEndorsingST;
    }
    
    public boolean isSignedST() {
        return signedST;
    }
    
    public void setSignedST(boolean signedST) {
        this.signedST = signedST;
    }
    
    public boolean isProtectSignature() {
        return protectSignature;
    }
    
    public void setProtectSignature(boolean protectSignature) {
        this.protectSignature = protectSignature;
    }
}
