/*
 * IssuerNameAndSerialCertSelector.java
 *
 * Created on February 28, 2007, 11:09 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.xml.wss.impl.misc;

import java.math.BigInteger;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;

import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.xml.wss.logging.LogDomainConstants;
import java.security.cert.X509Certificate;
import java.util.Arrays;

import com.sun.xml.wss.XWSSecurityException;

import java.security.cert.CertificateEncodingException;

/**
 *
 * @author kumar jayanti
 */
public class IssuerNameAndSerialCertSelector implements CertSelector {
    
    private final BigInteger serialNumber;
    private final String issuerName;
    
       /** logger */
    protected static final Logger log =  Logger.getLogger(
            LogDomainConstants.WSS_API_DOMAIN,LogDomainConstants.WSS_API_DOMAIN_BUNDLE);
  
    /** Creates a new instance of IssuerNameAndSerialCertSelector */
    public IssuerNameAndSerialCertSelector(BigInteger serialNum, String issuer) {
        this.serialNumber = serialNum;
        this.issuerName = issuer;
    }

    public boolean match(Certificate cert) {
        if (cert instanceof X509Certificate) {
           if (this.matchesIssuerSerialAndName(this.serialNumber, this.issuerName, (X509Certificate)cert)) {
               return true;
           }     
        }
        return false;
    }
    
    public Object clone() {
        return new IssuerNameAndSerialCertSelector(this.serialNumber, this.issuerName);
    }
    
    private boolean matchesIssuerSerialAndName(
        BigInteger serialNumberMatch,
        String issuerNameMatch,
        X509Certificate x509Cert) {

        BigInteger serialNumber = x509Cert.getSerialNumber();
        String issuerName =
            com.sun.org.apache.xml.internal.security.utils.RFC2253Parser.normalize(
                x509Cert.getIssuerDN().getName());

        if (serialNumber.equals(serialNumberMatch)
            && issuerName.equals(issuerNameMatch)) {
            return true;
        }
        return false;
    }
}
