/*
 * DigestCertSelector.java
 *
 * Created on February 26, 2007, 6:20 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.xml.wss.impl.misc;

import java.security.cert.CertSelector;
import java.security.cert.Certificate;

import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.xml.wss.logging.LogDomainConstants;
import java.security.cert.X509Certificate;
import java.util.Arrays;

import com.sun.xml.wss.XWSSecurityException;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.CertificateEncodingException;

/**
 *
 * @author Kumar Jayanti
 */
public class DigestCertSelector implements CertSelector {
    
    private final byte[] keyId;
    private final String algorithm;
     /** logger */
    protected static final Logger log =  Logger.getLogger(
            LogDomainConstants.WSS_API_DOMAIN,LogDomainConstants.WSS_API_DOMAIN_BUNDLE);
    
    
    
    /** Creates a new instance of KeyIdentifierCertSelector */
    public DigestCertSelector(byte[] keyIdValue, String algo) {
        this.keyId = keyIdValue;
        this.algorithm = algo;
    }

    public boolean match(Certificate cert) {
        if (cert instanceof X509Certificate) {
            byte[] thumbPrintIdentifier = null;
                                                                                                                      
            try {
                thumbPrintIdentifier = MessageDigest.getInstance(this.algorithm).digest(cert.getEncoded());
            } catch ( NoSuchAlgorithmException ex ) {
                log.log(Level.SEVERE, "WSS0708.no.digest.algorithm");
                throw new RuntimeException("Digest algorithm SHA-1 not found");
            } catch ( CertificateEncodingException ex) {
                log.log(Level.SEVERE, "WSS0709.error.getting.rawContent");
                throw new RuntimeException("Error while getting certificate's raw content");
            }
        
            if (Arrays.equals(thumbPrintIdentifier, keyId)) {
                return true;
            }  
        }
        return false;
    }
    
    public Object clone() {
        return new DigestCertSelector(this.keyId, this.algorithm);
    }
}