
/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.wss.impl.callback;

import javax.security.auth.Subject;
import org.w3c.dom.Element;
import javax.xml.stream.XMLStreamReader;

public interface SAMLAssertionValidator {

        /**
         * SAML validator.
         * @param assertion the assertion to be validated
         * successful validation.
         * @throws SAMLValidationException if the SAML Assertion is invalid
         */
        public void validate(Element assertion)
            throws SAMLValidationException;

        /**
         * SAML validator.
         * @param assertion the assertion to be validated
         * successful validation.
         * @throws SAMLValidationException if the SAML Assertion is invalid
         */
        public void validate(XMLStreamReader assertion)
            throws SAMLValidationException;

        public static class SAMLValidationException extends Exception {
                                                                                                                      
        public SAMLValidationException(String message) {
            super(message);
        }
                                                                                                                      
        public SAMLValidationException(String message, Throwable cause) {
            super(message, cause);
        }
                                                                                                                      
        public SAMLValidationException(Throwable cause) {
            super(cause);
        }
    }
}
