/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.util;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.wss.impl.MessageConstants;
/**
 *
 * @author K.Venugopal@sun.com
 */
public class WSSNamespacePrefixMapper extends NamespacePrefixMapper{
    
    private boolean soap12 = false;
    /** Creates a new instance of NamespacePrefixMapper */
    public WSSNamespacePrefixMapper() {
    }
    
    /** Creates a new instance of NamespacePrefixMapper */
    public WSSNamespacePrefixMapper(boolean soap12) {
        this.soap12 = soap12;
    }
    
    public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
        if(MessageConstants.WSSE_NS.equals(namespaceUri)){
            return MessageConstants.WSSE_PREFIX;
        }
        
        if(MessageConstants.WSSE11_NS.equals(namespaceUri)){
            return MessageConstants.WSSE11_PREFIX;
        }
        if(MessageConstants.XENC_NS.equals(namespaceUri)){
            return MessageConstants.XENC_PREFIX;
        }
        if(MessageConstants.DSIG_NS.equals(namespaceUri)){
            return MessageConstants.DSIG_PREFIX;
        }
        if(MessageConstants.WSU_NS.equals(namespaceUri)){
            return MessageConstants.WSU_PREFIX;
        }
        if(MessageConstants.WSSC_NS.equals(namespaceUri)){
            return MessageConstants.WSSC_PREFIX;
        }
        if("http://www.w3.org/2001/10/xml-exc-c14n#".equals(namespaceUri)){
            return "exc14n";
        }
        if(MessageConstants.SOAP_1_1_NS.equals(namespaceUri)){
            return "S";
        }
        
        if(MessageConstants.SOAP_1_2_NS.equals(namespaceUri)){
            return "S";
        }
        if("http://www.w3.org/2001/XMLSchema-instance".equals(namespaceUri)){
            return "xsi";
        }
        return null;
    }
    
    public String[] getPreDeclaredNamespaceUris() {
        return new String[] { };
    }
    
    public String[] getContextualNamespaceDecls() {
        if(!soap12){
            return new String[] {MessageConstants.WSSE_PREFIX, MessageConstants.WSSE_NS,MessageConstants.WSSE11_PREFIX,
            MessageConstants.WSSE11_NS,MessageConstants.XENC_PREFIX,MessageConstants.XENC_NS,MessageConstants.DSIG_PREFIX,MessageConstants.DSIG_NS,
            MessageConstants.WSU_PREFIX,MessageConstants.WSU_NS, MessageConstants.WSSC_PREFIX,MessageConstants.WSSC_NS,"exc14n","http://www.w3.org/2001/10/xml-exc-c14n#",
            "S",MessageConstants.SOAP_1_1_NS};
        }else{
            return new String[] {MessageConstants.WSSE_PREFIX, MessageConstants.WSSE_NS,MessageConstants.WSSE11_PREFIX,
            MessageConstants.WSSE11_NS,MessageConstants.XENC_PREFIX,MessageConstants.XENC_NS,MessageConstants.DSIG_PREFIX,MessageConstants.DSIG_NS,
            MessageConstants.WSU_PREFIX,MessageConstants.WSU_NS, MessageConstants.WSSC_PREFIX,MessageConstants.WSSC_NS,"exc14n","http://www.w3.org/2001/10/xml-exc-c14n#",
            "S",MessageConstants.SOAP_1_2_NS};
        }
    }
    
}
