/*

 * The contents of this file are subject to the terms

 * of the Common Development and Distribution License

 * (the License).  You may not use this file except in

 * compliance with the License.

 *

 * You can obtain a copy of the license at

 * https://glassfish.dev.java.net/public/CDDLv1.0.html.

 * See the License for the specific language governing

 * permissions and limitations under the License.

 *

 * When distributing Covered Code, include this CDDL

 * Header Notice in each file and include the License file

 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.

 * If applicable, add the following below the CDDL Header,

 * with the fields enclosed by brackets [] replaced by

 * you own identifying information:

 * "Portions Copyrighted [year] [name of copyright owner]"

 *

 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved

 */



package com.sun.xml.ws.security.opt.impl.util;



import java.util.ArrayList;

import java.util.Iterator;

import  com.sun.xml.wss.impl.MessageConstants;

/**

 *

 * @author K.Venugopal@sun.com

 */

public class NamespaceContextEx implements org.jvnet.staxex.NamespaceContextEx {

    private boolean addedWSSNS = false;
    private boolean samlNS = false;
    private boolean dsNS = false;
    private boolean encNS = false;
    private boolean scNS = false;
    private boolean exc14NS = false;
    private boolean addedWSS11NS = false;
    private ArrayList<org.jvnet.staxex.NamespaceContextEx.Binding> list = new ArrayList<org.jvnet.staxex.NamespaceContextEx.Binding>();
    /** Creates a new instance of NamespaceContextEx */

    public NamespaceContextEx() {
        this.add("S","http://schemas.xmlsoap.org/soap/envelope/" );
        addDefaultNSDecl();
    }
    
    
    public NamespaceContextEx(boolean soap12Version) {
        if(soap12Version){
            this.add("S","http://www.w3.org/2003/05/soap-envelope" );//SOAP 12
        }else{
            this.add("S","http://schemas.xmlsoap.org/soap/envelope/" );
        }    
        addDefaultNSDecl();
    }
    
    private void addDefaultNSDecl(){
        
    }
    
    public void addWSSNS(){
        if(!addedWSSNS){
            this.add("wsse", MessageConstants.WSSE_NS);
            this.add("wsu", MessageConstants.WSU_NS);
            addedWSSNS = true;
        }
    }
    
    public void addWSS11NS(){
         if(!addedWSS11NS){
            this.add("wsse11", MessageConstants.WSSE11_NS);            
            addedWSS11NS = true;
        }
    }
    
    public void addSignatureNS(){
        addWSSNS();
        if(!dsNS){
            this.add("ds", MessageConstants.DSIG_NS);
            dsNS = true;
        }
    }
    
    public void addEncryptionNS(){
        addWSSNS();
        if(!encNS){
            this.add("xenc", MessageConstants.XENC_NS);
            encNS = true;
        }
    }
    
    public void addSAMLNS(){
        if(!samlNS){
            this.add("saml", MessageConstants.SAML_v1_0_NS);
            samlNS = true;
        }
    }
    
    public void addSCNS(){
        if(!scNS){
            this.add("wsc", MessageConstants.WSSC_NS);
            scNS = true;
        }
    }
    
    public void addExc14NS(){
        if(!exc14NS){
            this.add("exc14n", "http://www.w3.org/2001/10/xml-exc-c14n#");
            exc14NS = true;
        }
    }
    
    public void add(String prefix,String uri){
        list.add(new BindingImpl(prefix,uri));   
    }
    
    public Iterator<org.jvnet.staxex.NamespaceContextEx.Binding> iterator() {
        return list.iterator();
    }
    
    public String getNamespaceURI(String prefix) {
        for(org.jvnet.staxex.NamespaceContextEx.Binding binding : list){
            if(prefix.equals(binding.getPrefix())){
                return binding.getNamespaceURI();
            }
        }
        return null;
    }
    
    public String getPrefix(String namespaceURI) {
        for(org.jvnet.staxex.NamespaceContextEx.Binding binding : list){
            if(namespaceURI.equals(binding.getNamespaceURI())){
                return binding.getPrefix();
            }
        }
        return null;
    }
    
    public Iterator getPrefixes(final String namespaceURI) {
        return new Iterator(){
            
            int index = 0;
            
            public boolean hasNext(){
                if(index++ < list.size() && move()){
                    return true;
                }
                return false;
            }
            
            public Object next(){
                return list.get(index).getPrefix();
            }
            
            public void remove() {
                throw new UnsupportedOperationException();
            }
            
            private boolean move(){
                boolean found = false;
                do{
                    if(namespaceURI.equals(list.get(index).getNamespaceURI())){
                        found = true;
                        break;
                    }else{
                        index++;
                    }
                }while(index < list.size());
                return found;
            }
        };
    }
    
    
    static class BindingImpl implements org.jvnet.staxex.NamespaceContextEx.Binding{
        private String prefix="";
        private String uri="";
        public BindingImpl(String prefix,String uri){
            this.prefix = prefix;
            this.uri = uri;
        }
        
        public String getPrefix() {
            return prefix;
        }
        
        public String getNamespaceURI() {
            return uri;
        }
        
    }
    
}