/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 *
 * @author Ashutosh.Shahi@Sun.com
 */
public class CheckedInputStream extends FilterInputStream{
    
    int read;
    boolean isEmpty = false;
    boolean xmlDecl = false;
    byte[] tmpBytes = new byte[4];
    ByteArrayInputStream tmpIs = null;
    
    /** Creates a new instance of CheckedCipherInputStream */
    public CheckedInputStream(InputStream cin) throws IOException {
        super(cin);
        read = cin.read();
        if(read == -1){
            isEmpty = true;
        }else{
            cin.read(tmpBytes, 0, 4);
            tmpIs = new ByteArrayInputStream(tmpBytes);
        }
    }
    
    public int read() throws IOException{
        if(read != -1){
            int tmp = read;
            read = -1;
            
            if(tmp == '<' && "?xml".equals(new String(tmpBytes))){
                xmlDecl = true;
                int c = super.read();
                while(c != '>'){
                    //do nothing
                    c = super.read();
                }
            }
            
            if(!xmlDecl){
                return tmp;
            }
        }
        
        if(!xmlDecl){
            int c = tmpIs.read();
            if(c != -1){
                return c;
            }
        }
        
        return super.read();
    }
    
    public int read(byte [] b) throws IOException{        
        return read(b,0,b.length);
    }
    
    public int read(byte[] b , int off, int len) throws IOException{
        if(read != -1){
            
            if(read == '<' && "?xml".equals(new String(tmpBytes))){
                xmlDecl = true;
                int c = super.read();
                while(c != '>'){
                    //do nothing
                    c = super.read();
                }
            }
            
            int i = 0;
            b[off + i] = (byte) read;
            i++;
            len--;
            read = -1;
            
            if(!xmlDecl){          
                
                int c = tmpIs.read();
                while(c != -1 && len > 0){
                    b[off + i] = (byte)c;
                    i++;
                    c = tmpIs.read();
                    len--;
                }              
                
            }
            int rb = 0;
            if(len > 0){
                rb = super.read(b,off+i,len);
            }
            
            return rb+i;
        }
        return super.read(b,off,len);
    }
    public long skip(long n) throws IOException {
        if(read != -1){
            read = -1;
            return super.skip(n-1) + 1;
        }
        return super.skip(n);
    }
    
    public boolean isEmpty(){
        return isEmpty;
    }
}
