/*
 * Timestamp.java
 *
 * Created on August 30, 2006, 11:16 PM
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.tokens;

import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import com.sun.xml.ws.security.wsu10.ObjectFactory;
import com.sun.xml.ws.security.wsu10.TimestampType;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.SOAPVersion;
import javax.xml.stream.XMLStreamException;

import com.sun.xml.wss.XWSSecurityException;

/**
 * Representation of Timestamp SecurityHeaderElement
 * @author Ashutosh.Shahi@sun.com
 */
public class Timestamp extends TimestampType
          implements com.sun.xml.ws.security.opt.api.tokens.Timestamp, 
          SecurityHeaderElement, SecurityElementWriter{
    
    private long timeout = 0;
    private SOAPVersion soapVersion = SOAPVersion.SOAP_11;
    private ObjectFactory objFac = new ObjectFactory();
    
    /**
     * Creates a new instance of Timestamp
     * @param sv the soapVersion for this message
     */
    public Timestamp(SOAPVersion sv) {
        this.soapVersion = sv;
    }
    
    /**
     * 
     * @param created set the creation time on timestamp
     */
    public void setCreated(final String created){
        AttributedDateTime timeCreated = objFac.createAttributedDateTime();
        timeCreated.setValue(created);
        setCreated(timeCreated);
    }
    
    /**
     * 
     * @param expires set the expiry time on timestamp
     */
    public void setExpires(final String expires){
        AttributedDateTime timeExpires = objFac.createAttributedDateTime();
        timeExpires.setValue(expires);
        setExpires(timeExpires);
    }
    
    /**
     * 
     * @return the creation time value
     */
    public String getCreatedValue(){
        String createdValue = null;
        AttributedDateTime created = getCreated();
        if(created != null)
            createdValue = created.getValue();
        return createdValue;
    }
    
    /**
     * 
     * @return the expiry time value
     */
    public String getExpiresValue(){
        String expiresValue = null;
        AttributedDateTime expires = getExpires();
        if(expires != null)
            expiresValue = expires.getValue();
        return expiresValue;
    }
    
    /**
     * The timeout is assumed to be in seconds
     */
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
    
    public String getNamespaceURI() {
        return MessageConstants.WSU_NS;
    }
    
    public String getLocalPart() {
        return MessageConstants.TIMESTAMP_LNAME;
    }
    
    public String getAttribute(String nsUri, String localName) {
        QName qname = new QName(nsUri, localName);
        Map<QName, String> otherAttributes = this.getOtherAttributes();
        return otherAttributes.get(qname);
    }
    
    public String getAttribute(QName name) {
        Map<QName, String> otherAttributes = this.getOtherAttributes();
        return otherAttributes.get(name);
    }
    
    public javax.xml.stream.XMLStreamReader readHeader() throws javax.xml.stream.XMLStreamException {
        XMLStreamBufferResult xbr = new XMLStreamBufferResult();
        JAXBElement<TimestampType> tsElem = new ObjectFactory().createTimestamp(this);
        try{
            getMarshaller().marshal(tsElem, xbr);
            
        } catch(JAXBException je){
            throw new XMLStreamException(je);
        }
        return xbr.getXMLStreamBuffer().readAsXMLStreamReader();
    }
    
    /**
     * 
     * @param os 
     */
    public void writeTo(OutputStream os) {
    }
    
    /**
     * Writes out the header.
     *
     * @throws XMLStreamException
     *      if the operation fails for some reason. This leaves the
     *      writer to an undefined state.
     */
    public void writeTo(javax.xml.stream.XMLStreamWriter streamWriter) throws javax.xml.stream.XMLStreamException {
        JAXBElement<TimestampType> tsElem = new ObjectFactory().createTimestamp(this);
        try {
            // If writing to Zephyr, get output stream and use JAXB UTF-8 writer
            if (streamWriter instanceof Map) {
                OutputStream os = (OutputStream) ((Map) streamWriter).get("sjsxp-outputstream");
                if (os != null) {
                    streamWriter.writeCharacters("");        // Force completion of open elems
                    getMarshaller().marshal(tsElem, os);
                    return;
                }
            }
            
            getMarshaller().marshal(tsElem,streamWriter);
        } catch (JAXBException e) {
            throw new XMLStreamException(e);
        }
    }
    
    private Marshaller getMarshaller() throws JAXBException{
        return JAXBUtil.createMarshaller(soapVersion);
    }
    
    /*
     * The <wsu:Created> element specifies a timestamp used to
     * indicate the creation time. It is defined as part of the
     * <wsu:Timestamp> definition.
     *
     * Time reference in WSS work should be in terms of
     * dateTime type specified in XML Schema in UTC time(Recommmended)
     */
    public void createDateTime() throws XWSSecurityException {
        if (created == null) {
            Calendar c = new GregorianCalendar();
            int offset = c.get(Calendar.ZONE_OFFSET);
            if (c.getTimeZone().inDaylightTime(c.getTime())) {
                offset += c.getTimeZone().getDSTSavings();
            }
            synchronized (calendarFormatter1) {
                calendarFormatter1.setTimeZone(c.getTimeZone());
                
                // always send UTC/GMT time
                long beforeTime = c.getTimeInMillis();
                long currentTime = 0;
                currentTime = beforeTime - offset;
                c.setTimeInMillis(currentTime);
                // finished UTC/GMT adjustment
                
                setCreated(calendarFormatter1.format(c.getTime()));
                
                c.setTimeInMillis(currentTime + timeout);
                setExpires(calendarFormatter1.format(c.getTime()));
            }
        }
    }
    
    /**
     * 
     * @param id 
     * @return 
     */
    public boolean refersToSecHdrWithId(String id) {
        return false;
    }

    /**
     * 
     * @param streamWriter 
     * @param props 
     * @throws javax.xml.stream.XMLStreamException 
     */
    public void writeTo(javax.xml.stream.XMLStreamWriter streamWriter, HashMap props) throws javax.xml.stream.XMLStreamException {
        try{
            Marshaller marshaller = getMarshaller();
            Iterator<Map.Entry<Object, Object>> itr = props.entrySet().iterator();
            while(itr.hasNext()){
                Map.Entry<Object, Object> entry = itr.next();
                marshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
            writeTo(streamWriter);
        }catch(JAXBException jbe){
            throw new XMLStreamException(jbe);
        }
    }
    
    public static final SimpleDateFormat calendarFormatter1
              = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    
}
