/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.message;

import com.sun.xml.ws.message.jaxb.JAXBHeader;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.dsig.SignedMessageHeader;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.util.WSSElementFactory;
import com.sun.xml.ws.security.opt.impl.crypto.JAXBDataImpl;
import com.sun.xml.ws.security.opt.impl.crypto.SSBData;
import com.sun.xml.ws.security.opt.impl.crypto.SSEData;
import com.sun.xml.ws.security.opt.impl.crypto.StreamHeaderData;
import com.sun.xml.ws.security.opt.impl.util.WSSNSPrefixWrapper;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy.FeatureBinding;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.wss.impl.policy.mls.Target;

import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.namespace.QName;

import com.sun.xml.ws.api.SOAPVersion;
/**
 *
 * @author K.Venugopal@sun.com
 */
public class ETHandler {
    private WSSElementFactory wsf = null;
    private HashMap props = new HashMap();
    /** Creates a new instance of MessageETHandler */
    public ETHandler(SOAPVersion soapVersion) {
        wsf = new WSSElementFactory(soapVersion);
        if(soapVersion == SOAPVersion.SOAP_11){
            props.put("com.sun.xml.bind.namespacePrefixMapper", new WSSNSPrefixWrapper(JAXBUtil.prefixMapper11));
        } else{
            props.put("com.sun.xml.bind.namespacePrefixMapper", new WSSNSPrefixWrapper(JAXBUtil.prefixMapper12));
        }
    }
    
    
    public List buildEDList( EncryptionPolicy policy,final Target target ,JAXBFilterProcessingContext context,Key key,KeyInfo ki) throws XWSSecurityException{
        
        SecuredMessage message = context.getSecuredMessage();
        ArrayList edList = new ArrayList();
        if(target.getType() == Target.TARGET_TYPE_VALUE_QNAME){
            QName name = target.getQName();
            if(name == Target.BODY_QNAME){
                Object obj = message.getBody();
                String dataEncAlg =  SecurityUtil.getDataEncryptionAlgo(context);
                if(dataEncAlg.length() == 0){
                    if (context.getAlgorithmSuite() != null) {
                        dataEncAlg = context.getAlgorithmSuite().getEncryptionAlgorithm();
                    }
                }
                Data data = null;
                if(obj instanceof SOAPBody){
                    data =  new SSBData((SOAPBody)obj,true, context.getNamespaceContext());
                    SecurityHeaderElement ed = (SecurityHeaderElement) wsf.createEncryptedData(context.generateID(),data,dataEncAlg,ki,key,true);
                    edList.add(ed);
                    SOAPBody sb =(SOAPBody) message.getBody();
                    SOAPBody nsb = new SOAPBody(ed,context.getSOAPVersion());
                    nsb.setId(sb.getId());
                    message.replaceBody(nsb);
                }else if(obj instanceof SecurityElement){
                    data = new SSEData((SecurityElement)obj, true, context.getNamespaceContext(), props);
                    SecurityHeaderElement ed = (SecurityHeaderElement) wsf.createEncryptedData(context.generateID(),data,dataEncAlg,ki,key,true);
                    edList.add(ed);
                    SOAPBody nsb = new SOAPBody(ed,context.getSOAPVersion());
                    nsb.setId(((SecurityElement)obj).getId());
                    message.replaceBody(nsb);
                }
                return edList;
            }
            
            // Look for Id or wsu:Id attribute in all elements
            java.util.Iterator headers = null;
            if(name.getNamespaceURI().equals(MessageConstants.ADDRESSING_MEMBER_SUBMISSION_NAMESPACE) ||
                    name.getNamespaceURI().equals(MessageConstants.ADDRESSING_W3C_NAMESPACE)){
                if(!"".equals(name.getLocalPart()))
                    headers = message.getHeaders(name.getLocalPart(), null);
                else{
                    headers = message.getHeaders(MessageConstants.ADDRESSING_MEMBER_SUBMISSION_NAMESPACE);
                    if(!headers.hasNext())
                        headers = message.getHeaders(MessageConstants.ADDRESSING_W3C_NAMESPACE);
                }
            } else {
                if(!"".equals(name.getLocalPart()))
                    headers = message.getHeaders(name.getLocalPart(), name.getNamespaceURI());
                else
                    headers = message.getHeaders(name.getNamespaceURI());
            }
            
            while(headers.hasNext()){
                Object header = headers.next();
                SecurityHeaderElement ed = toMessageHeader(policy,target,context,key,header,ki, true);
                edList.add(ed);
            }
            
            if(!edList.isEmpty()){
                return edList;
            }
            SecurityHeader sh = context.getSecurityHeader();
            
            Iterator itr = sh.getHeaders(name.getLocalPart(),name.getNamespaceURI());
            while(itr.hasNext()){
                SecurityHeaderElement hdr = (SecurityHeaderElement)itr.next();
                if(hdr != null){
                    SecurityHeaderElement ed = toMessageHeader(policy,target,context,key,hdr,ki, false);
                    edList.add(ed);
                }
            }
            return edList;
        }else if(target.getType() == Target.TARGET_TYPE_VALUE_URI){
            
            SecurityHeaderElement se = handleURI(policy,target,context,key,ki);
            edList.add(se);
            return edList;
            //TODO
            // throw new UnsupportedOperationException("Target Type "+target.getType() +" is not supported by EncryptionProcessor");
        }
        throw new UnsupportedOperationException("Target Type "+target.getType() +" is not supported by EncryptionProcessor");
        
    }
    
    
    protected SecurityHeaderElement handleURI(EncryptionPolicy policy,Target target ,JAXBFilterProcessingContext context,Key key,KeyInfo ki) throws XWSSecurityException{
        String dataEncAlg =  SecurityUtil.getDataEncryptionAlgo(context);
        boolean contentOnly = target.getContentOnly();
        Object header = context.getSecurityHeader().getChildElement(target.getValue());
        if(header != null){
            Data data = toData(header,contentOnly, context);
            SecurityHeaderElement ed = (SecurityHeaderElement) wsf.createEncryptedData(context.generateID(),data,dataEncAlg,ki,key,target.getContentOnly());
            context.getSecurityHeader().replace((SecurityHeaderElement) header, ed);
            return ed;
        }else{
            header = context.getSecuredMessage().getHeader(target.getValue());
            return toMessageHeader(policy,target,context,key,header,ki, true);
        }
    }
    
    protected SecurityHeaderElement toMessageHeader(EncryptionPolicy policy,Target target ,JAXBFilterProcessingContext context,
            Key key,Object header,KeyInfo ki, boolean isEncryptedHeaders) throws XWSSecurityException{
        SecuredMessage message = context.getSecuredMessage();
        String dataEncAlg =  SecurityUtil.getDataEncryptionAlgo(context);
        boolean contentOnly = target.getContentOnly();
        
        boolean encHeaderContent = context.getEncHeaderContent();
        if(encHeaderContent && !"true".equals(context.getExtraneousProperty("EnableWSS11PolicySender"))){
            contentOnly = true;
        }
        
        Data data = toData(header,contentOnly, context);
        SecurityHeaderElement ed = null;
        
        if(contentOnly){
            ed = (SecurityHeaderElement) wsf.createEncryptedData(context.generateID(),data,dataEncAlg,ki,key,contentOnly);
            if(header instanceof com.sun.xml.ws.security.opt.impl.message.Header){
                throw new XWSSecurityException("Implementation does not support encrypting content which is already encrypted ");
            } else if(header instanceof SignedMessageHeader){
                EncryptedSignedMessageHeader encHdr = new EncryptedSignedMessageHeader((SignedMessageHeader)header, ed);
                message.replaceHeader(header, encHdr);
            } else{
                com.sun.xml.ws.security.opt.impl.message.Header hdr = new com.sun.xml.ws.security.opt.impl.message.Header((com.sun.xml.ws.api.message.Header)header,ed);
                message.replaceHeader(header,hdr);
            }
            
        }else{
            if(isEncryptedHeaders && "true".equals(context.getExtraneousProperty("EnableWSS11PolicySender"))){
                ed = (SecurityHeaderElement) wsf.createEncryptedHeader(context.generateID(),context.generateID(),data,dataEncAlg,ki,key,contentOnly);
                ((NamespaceContextEx)context.getNamespaceContext()).addWSS11NS();
            } else{
                ed = (SecurityHeaderElement) wsf.createEncryptedData(context.generateID(),data,dataEncAlg,ki,key,contentOnly);
            }
            if(!message.replaceHeader(header,ed)){
                context.getSecurityHeader().replace((SecurityHeaderElement) header, ed);
            }
        }
        return ed;
    }
    
    
    protected Data toData(Object header,boolean contentOnly, JAXBFilterProcessingContext context)throws XWSSecurityException{
        if(header instanceof SecurityElement){
            return new SSEData((SecurityElement)header,contentOnly, context.getNamespaceContext(), props);
        }if(header instanceof JAXBHeader){
            return new  JAXBDataImpl((com.sun.xml.ws.api.message.Header) header, contentOnly, context.getNamespaceContext());
        }else if(header instanceof com.sun.xml.ws.api.message.Header){
            return new StreamHeaderData((com.sun.xml.ws.api.message.Header)header,contentOnly, context.getNamespaceContext());
        }else{
            throw new XWSSecurityException("Unsupported Header type");
        }
    }
}
