/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.api.security.trust.client.IssuedTokenManager;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.api.reference.DirectReference;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.secconv.impl.client.SCTokenProviderImpl;
import java.security.Key;
import java.util.logging.Level;
import javax.crypto.spec.SecretKeySpec;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class SCTBuilder extends TokenBuilder{
    private SecureConversationTokenKeyBinding sctBinding = null;
    /** Creates a new instance of SCTBuilder */
    public SCTBuilder(JAXBFilterProcessingContext context,SecureConversationTokenKeyBinding kb) {
        super(context);
        this.sctBinding = kb;
        
    }
    
    public BuilderResult process() throws XWSSecurityException {
        BuilderResult sctResult = new BuilderResult();
        
        String dataEncAlgo = SecurityUtil.getDataEncryptionAlgo(context);
        
        String sctPolicyId = sctBinding.getUUID();
        //Look for SCT in TokenCache
        SecurityElement sct = context.getSecurityHeader().getChildElement(sctPolicyId);
        IssuedTokenContext ictx = context.getSecureConversationContext();
        boolean includeToken = (sctBinding.INCLUDE_ALWAYS.equals(sctBinding.getIncludeToken()) ||
                (sctBinding.INCLUDE_ALWAYS_TO_RECIPIENT.equals(sctBinding.getIncludeToken())));
        com.sun.xml.ws.security.SecurityContextToken sct1 = null;
        if (sct == null) {
            sct1 =(com.sun.xml.ws.security.SecurityContextToken)ictx.getSecurityToken();
            if (sct1 == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1809_SCT_NOT_FOUND());
                throw new XWSSecurityException("SecureConversation Token not Found");
            }
            sct  = context.getSecurityHeader().getChildElement(sct1.getWsuId());
            if(sct == null){
                sct1 = com.sun.xml.wss.impl.misc.SecurityUtil.getSCT(sct1, context.getSOAPVersion());
                if(includeToken){
                    if(context.getSecurityPolicyVersion().equals(MessageConstants.SECURITYPOLICY_12_NS)){
                        context.getSecurityHeader().add((SecurityContextToken13)sct1);
                    }else{
                        context.getSecurityHeader().add((SecurityContextToken)sct1);
                    }
                }           
                
                if(context.getSecurityPolicyVersion().equals(MessageConstants.SECURITYPOLICY_12_NS)){
                    sct = (SecurityContextToken13)sct1;
                }else{
                    sct = (SecurityContextToken)sct1;
                }                
            }
            //Add ext elements;
        }
        
        String sctWsuId = sct.getId();
        if (sctWsuId == null) {
            sct.setId(context.generateID());
            sctWsuId = sct.getId();
        }        
        
        Key dataProtectionKey = null;
        
        DirectReference directRef = elementFactory.createDirectReference();
        if(includeToken){
            directRef.setURI("#"+sctWsuId);
        } else{
            directRef.setURI(sct1.getIdentifier().toString());            
        }
        
        if (!sctBinding.INCLUDE_ALWAYS_TO_RECIPIENT.equals(sctBinding.getIncludeToken()) ||
                !sctBinding.INCLUDE_ALWAYS.equals(sctBinding.getIncludeToken())) {
            if(context.getSecurityPolicyVersion().equals(MessageConstants.SECURITYPOLICY_12_NS)){
                directRef.setValueType(MessageConstants.SCT_13_VALUETYPE);                
            }else{
                directRef.setValueType(MessageConstants.SCT_VALUETYPE);                
            }
        }
        
        if(sct1.getInstance() != null && !context.isExpired()){
            ((com.sun.xml.ws.security.opt.impl.reference.DirectReference)directRef).setAttribute(
                    context.getWSSCVersion(context.getSecurityPolicyVersion()), "Instance", sct1.getInstance());
        }
        
        byte[] proofKey = null;        
        if(sct1.getInstance() != null){
            if(context.isExpired()){
                proofKey = ictx.getProofKey();
            }else{
                SecurityContextTokenInfo sctInstanceInfo = ictx.getSecurityContextTokenInfo();
                proofKey = sctInstanceInfo.getInstanceSecret(sct1.getInstance());
            }
        }else{
            proofKey = ictx.getProofKey();
        }
                
        String jceAlgo = SecurityUtil.getSecretKeyAlgorithm(dataEncAlgo);
        //dataProtectionKey = new SecretKeySpec(ictx.getProofKey(), jceAlgo);
        dataProtectionKey = new SecretKeySpec(proofKey, jceAlgo);
        buildKeyInfo(directRef,context.generateID());
        sctResult.setKeyInfo(super.keyInfo);
        sctResult.setDataProtectionKey(dataProtectionKey);
        return sctResult;
    }
}
