/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.incoming.processor;

import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class ReferenceListProcessor {
    
    ArrayList<String> refList = null;
    //EncryptionPolicy encPolicy = null;
    EncryptionPolicy.FeatureBinding fb = null;
    /** Creates a new instance of ReferenceListProcessor */
    public ReferenceListProcessor(EncryptionPolicy encPolicy) {
        //this.encPolicy = encPolicy;
        fb = (EncryptionPolicy.FeatureBinding) encPolicy.getFeatureBinding();
    }
    
    public void process(XMLStreamReader reader) throws XMLStreamException{
        refList = new ArrayList<String>(2);
        if(StreamUtil.moveToNextStartOREndElement(reader)){
            while(reader.getEventType() != reader.END_DOCUMENT){
                if(reader.getEventType() == XMLStreamReader.START_ELEMENT){
                    if(reader.getLocalName() == "DataReference" && reader.getNamespaceURI() == MessageConstants.XENC_NS){
                        String uri = reader.getAttributeValue(null,"URI");
                        if(uri.startsWith("#")){
                            refList.add(uri.substring(1));
                        }else{
                            refList.add(uri);
                        }
                        // for policy creation
                        Target target = new Target(Target.TARGET_TYPE_VALUE_URI, uri);
                        EncryptionTarget encTarget = new EncryptionTarget(target);
                        fb.addTargetBinding(encTarget);
                    }
                }
                if(_exit(reader)){
                    break;
                }
                reader.next();
                
                if(_exit(reader)){
                    break;
                }
            }
        }
    }
    
    public ArrayList<String> getReferences(){
        return refList;
    }
    
    public boolean _exit(XMLStreamReader reader){
        if(reader.getEventType() == XMLStreamReader.END_ELEMENT){
            if(reader.getLocalName() == "ReferenceList" && reader.getNamespaceURI() == MessageConstants.XENC_NS){
               return true;
            }
        }
        return false;
    }
}
