/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.incoming.processor;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.logging.LogDomainConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.XMLStreamReaderEx;
import com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class CipherDataProcessor {
    
    private static final Logger logger = Logger.getLogger(LogDomainConstants.IMPL_OPT_CRYPTO_DOMAIN,
            LogDomainConstants.IMPL_OPT_CRYPTO_DOMAIN_BUNDLE);
    
    private static String CIPHER_VALUE = "CipherValue".intern();
    private Base64Data bd = null;
    private byte[] cipherValue;
    /** Creates a new instance of CipherDataProcessor */
    public CipherDataProcessor() {
    }
    
    public void process(XMLStreamReader reader) throws XWSSecurityException{
        try {
            if(StreamUtil.moveToNextElement(reader)){
                if(reader.getLocalName() == CIPHER_VALUE){
                    if(reader instanceof XMLStreamReaderEx){
                        reader.next();
                        if(reader.getEventType() == XMLStreamReader.CHARACTERS){
                            CharSequence charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                            if(charSeq instanceof Base64Data){
                                bd = (Base64Data) charSeq;
                            }else{
                                try {
                                    cipherValue = Base64.decode(StreamUtil.getCV((XMLStreamReaderEx)reader));
                                } catch (Base64DecodingException ex) {
                                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1922_ERROR_DECODING_CIPHERVAL(ex));
                                    throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, LogStringsMessages.WSS_1922_ERROR_DECODING_CIPHERVAL(ex), ex);
                                }
                            }
                        }
                    }else{
                        
                        try {
                            //cipherValue = Base64.decode(reader.getElementText());
                            cipherValue = Base64.decode(StreamUtil.getCV(reader));
                        } catch (Base64DecodingException ex) {
                            logger.log(Level.SEVERE, LogStringsMessages.WSS_1922_ERROR_DECODING_CIPHERVAL(ex));
                            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, LogStringsMessages.WSS_1922_ERROR_DECODING_CIPHERVAL(ex), ex);
                        }
                        
                    }
                    //reader.next();//move to END OF CIPHER VALUE
                    reader.next();//move to END OF CIPHER DATA
                    reader.next();//move to NEXT ELEMENT
                    return;
                }
            }
            reader.next();
        } catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1923_ERROR_PROCESSING_CIPHERVAL(ex));
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK,LogStringsMessages.WSS_1923_ERROR_PROCESSING_CIPHERVAL(ex),ex);
        }
        logger.log(Level.SEVERE, LogStringsMessages.WSS_1923_ERROR_PROCESSING_CIPHERVAL("unexpected element:"+reader.getLocalName()));
        throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK,LogStringsMessages.WSS_1923_ERROR_PROCESSING_CIPHERVAL("unexpected element:"+reader.getLocalName()), null);
        
    }
    
    public InputStream readAsStream() throws XWSSecurityException{
        
        if(bd != null ){
            try {
                return bd.getInputStream();
            } catch (IOException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1923_ERROR_PROCESSING_CIPHERVAL(ex));
                throw new XWSSecurityException(LogStringsMessages.WSS_1923_ERROR_PROCESSING_CIPHERVAL(ex));
            }
        }
        if(cipherValue != null){
            return new ByteArrayInputStream(cipherValue);
        }
        logger.log(Level.SEVERE, LogStringsMessages.WSS_1924_CIPHERVAL_MISSINGIN_CIPHERDATA());
        throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK,LogStringsMessages.WSS_1924_CIPHERVAL_MISSINGIN_CIPHERDATA(),null);
    }
    
    
    public byte[] readAsBytes() throws XWSSecurityException{
        if(cipherValue != null){
            return cipherValue;
        }
        if(bd != null ){
            cipherValue = bd.getExact();
            return cipherValue;
        }
        logger.log(Level.SEVERE, LogStringsMessages.WSS_1924_CIPHERVAL_MISSINGIN_CIPHERDATA());
        throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK,LogStringsMessages.WSS_1924_CIPHERVAL_MISSINGIN_CIPHERDATA(),null);
    }
}
