/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.crypto;

import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.impl.util.XMLStreamFilter;
import com.sun.xml.ws.security.opt.crypto.StreamWriterData;
import java.util.HashMap;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.staxex.NamespaceContextEx;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
/**
 *
 * @author K.Venugopal@sun.com
 */
public class SSEData implements StreamWriterData {
    
    private NamespaceContextEx nsContext;
    private boolean contentOnly;
    private SecurityElement data;
    private XMLStreamBuffer buffer = null;
    private HashMap props = new HashMap();
    
    /** Creates a new instance of SSEData */
    public SSEData(SecurityElement se , boolean contentOnly,NamespaceContextEx ns ) {
        this.data = se;
        this.nsContext = ns;
        this.contentOnly = contentOnly;
        //props.put("com.sun.xml.bind.namespacePrefixMapper", new WSSNSPrefixWrapper(JAXBUtil.prefixMapper11));
    }
    
    public SSEData(SecurityElement se , boolean contentOnly,NamespaceContextEx ns, HashMap props ) {
        this.data = se;
        this.nsContext = ns;
        this.contentOnly = contentOnly;
        this.props = props;
    }
    
    public SSEData(XMLStreamBuffer buffer){
        this.buffer = buffer;
    }
    
    public NamespaceContextEx getNamespaceContext() {
        return nsContext;
    }
    
    public SecurityElement getSecurityElement(){
        return data;
    }
    
    public void write(javax.xml.stream.XMLStreamWriter writer) throws javax.xml.stream.XMLStreamException {
        if(buffer != null){
            buffer.writeToXMLStreamWriter(writer);
        }
        
        if(contentOnly){
            XMLStreamWriter fw;
            fw = new XMLStreamFilter(writer, (com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx)nsContext);
            if(props != null){
                ((SecurityElementWriter)data).writeTo(fw,props);
            }else{
                ((SecurityElementWriter)data).writeTo(fw);
            }
        }else{
            if(props != null){
                ((SecurityElementWriter)data).writeTo(writer,props);
            }else{
                ((SecurityElementWriter)data).writeTo(writer);
            }
        }
    }
    
}
