/*
 * KeyValue.java
 *
 * Created on January 24, 2006, 4:49 PM
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.crypto.dsig.keyinfo;

import java.math.BigInteger;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *
 * @author Abhijit Das
 */
@XmlRootElement(name="KeyValue", namespace = "http://www.w3.org/2000/09/xmldsig#")
public class KeyValue extends com.sun.xml.security.core.dsig.KeyValueType implements javax.xml.crypto.dsig.keyinfo.KeyValue {
    
    /** Creates a new instance of KeyValue */
    public KeyValue() {
    }
    
    public PublicKey getPublicKey() throws KeyException {
        PublicKey publicKey = null;
        for ( Object o : content) {
            if ( o instanceof DSAKeyValue) {
                DSAKeyValue dsaKeyValue = (DSAKeyValue) o;
                
                DSAPublicKeySpec spec = new DSAPublicKeySpec(
                        new BigInteger(dsaKeyValue.getY()),
                        new BigInteger(dsaKeyValue.getP()),
                        new BigInteger(dsaKeyValue.getQ()),
                        new BigInteger(dsaKeyValue.getG()) );
                try {
                    KeyFactory fac = KeyFactory.getInstance("DSA");
                    return fac.generatePublic(spec);
                } catch (Exception ex) {
                    throw new KeyException(ex);
                }
            } else if ( o instanceof RSAKeyValue) {
                RSAKeyValue rsaKayValue = (RSAKeyValue) o;
                
                RSAPublicKeySpec spec = new RSAPublicKeySpec(
                        new BigInteger(rsaKayValue.getModulus()),
                        new BigInteger(rsaKayValue.getExponent()));
                
                try {
                    KeyFactory fac = KeyFactory.getInstance("RSA");
                    return fac.generatePublic(spec);
                } catch (Exception ex) {
                    throw new KeyException(ex);
                }
            }
        }
        return null;
    }
    
    public boolean isFeatureSupported(String string) {
        return false;
    }
    
    public void setContent(List<Object> content ) {
        this.content = content;
    }
    
}
