/*
 * CanonicalizationMethod.java
 *
 * Created on January 24, 2006, 2:25 PM
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.crypto.dsig;

import com.sun.xml.security.core.dsig.CanonicalizationMethodType;
import com.sun.xml.wss.logging.LogDomainConstants;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.crypto.Data;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import java.util.logging.Level;
/**
 *
 * @author Abhijit Das
 * @author K.Venugopal@sun.com
 */
@XmlRootElement(name="CanonicalizationMethod",namespace = "http://www.w3.org/2000/09/xmldsig#")
public class CanonicalizationMethod extends CanonicalizationMethodType implements javax.xml.crypto.dsig.CanonicalizationMethod {
    @XmlTransient private static final Logger logger = Logger.getLogger(LogDomainConstants.IMPL_OPT_SIGNATURE_DOMAIN,
    LogDomainConstants.IMPL_OPT_SIGNATURE_DOMAIN_BUNDLE);
    
    @XmlTransient private Exc14nCanonicalizer _exc14nCanonicalizer = new Exc14nCanonicalizer();
    @XmlTransient private AlgorithmParameterSpec _algSpec = null;
    
    /** Creates a new instance of CanonicalizationMethod */
    public CanonicalizationMethod() {
    }
    
    public void setParameterSpec(AlgorithmParameterSpec algSpec) {
        this._algSpec = algSpec;
    }
    
    public AlgorithmParameterSpec getParameterSpec() {
        return _algSpec;
    }
    
    
    public boolean isFeatureSupported(String string) {
        //TODO:
        return false;
    }
    
    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws TransformException {
        if(algorithm == CanonicalizationMethod.EXCLUSIVE){
            try {
                _exc14nCanonicalizer.init((TransformParameterSpec) _algSpec);
            } catch (InvalidAlgorithmParameterException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1758_TRANSFORM_INIT(),ex);
                throw new TransformException(ex);
            }
            _exc14nCanonicalizer.transform(data,xMLCryptoContext);
        }
        return null;
        
    }
    
    public Data transform(Data data, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) throws TransformException {
        if(algorithm == CanonicalizationMethod.EXCLUSIVE){
            _exc14nCanonicalizer.transform(data,xMLCryptoContext,outputStream);
        }
        return null;
    }
    
    
    public void setContent(List content) {
        this.content = content;
    }
}
