/*
 * KeyIdentifier.java
 *
 * Created on August 7, 2006, 12:23 PM
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.api.reference;

/**
 * Interface for KeyIdentifier reference type inside a STR
 * @author Ashutosh.Shahi@sun.com
 */
public interface KeyIdentifier extends Reference{
    
    /**
     * 
     * @return the valueType attribute for KeyIdentifier
     */
    String getValueType();
    
    /**
     * 
     * @param valueType the valueType attribute for KeyIdentifier
     */
    void setValueType(final String valueType);
    
    /**
     * 
     * @return the encodingType attribute
     */
    String getEncodingType();
    
    /**
     * 
     * @param value the encodingType attribute
     */
    void setEncodingType(final String value);
    
    /**
     * 
     * @return the referenced value by this key identifier
     */
    String getReferenceValue();
    
    /**
     * 
     * @param referenceValue the referenced value by this keyIdentifier
     */
    void setReferenceValue(final String referenceValue);
    
}
