/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.api.keyinfo;

import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.math.BigInteger;

/**
 *
 * @author K.Venugopal@sun.com
 */
public interface DerivedKeyToken {
    /**
     * Gets the value of the algorithm property.
     * 
     * 
     * @return possible object is
     *     {@link String }
     */
    String getAlgorithm();

    /**
     * Gets the value of the generation property.
     * 
     * 
     * @return possible object is
     *     {@link BigInteger }
     */
    BigInteger getGeneration();

    /**
     * Gets the value of the id property.
     * 
     * 
     * @return possible object is
     *     {@link String }
     */
    String getId();

    /**
     * Gets the value of the label property.
     * 
     * 
     * @return possible object is
     *     {@link String }
     */
    String getLabel();

    /**
     * Gets the value of the length property.
     * 
     * 
     * @return possible object is
     *     {@link BigInteger }
     */
    BigInteger getLength();

    /**
     * Gets the value of the nonce property.
     * 
     * 
     * @return possible object is
     *     byte[]
     */
    byte[] getNonce();

    /**
     * Gets the value of the offset property.
     * 
     * 
     * @return possible object is
     *     {@link BigInteger }
     */
    BigInteger getOffset();

    /**
     * Gets the value of the securityTokenReference property.
     * 
     * 
     * @return possible object is
     *     {@link SecurityTokenReferenceType }
     */
    SecurityTokenReferenceType getSecurityTokenReference();

    /**
     * Sets the value of the algorithm property.
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     */
    void setAlgorithm(String value);

    /**
     * Sets the value of the generation property.
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     */
    void setGeneration(BigInteger value);

    /**
     * Sets the value of the id property.
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     */
    void setId(String value);

    /**
     * Sets the value of the label property.
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     */
    void setLabel(String value);

    /**
     * Sets the value of the length property.
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     */
    void setLength(BigInteger value);

    /**
     * Sets the value of the nonce property.
     * 
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    void setNonce(byte[] value);

    /**
     * Sets the value of the offset property.
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     */
    void setOffset(BigInteger value);

    /**
     * Sets the value of the securityTokenReference property.
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link SecurityTokenReferenceType }
     */
    void setSecurityTokenReference(SecurityTokenReferenceType value);
    
}
