/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

/*
 * InclusiveNamespaces.java
 *
 * Created on August 29, 2006, 6:09 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.xml.security.core.dsig;

import javax.xml.bind.annotation.XmlAttribute;

/**
 *
 * @author K.Venugopal@sun.com
 */
//@XmlRootElement(name="ReferenceType")
//@XmlAccessorType(XmlAccessType.FIELD)
public class InclusiveNamespacesType {
    
    @XmlAttribute(name = "PrefixList", required = true)
    protected String prefixList;
    
    /** Creates a new instance of InclusiveNamespaces */
    public InclusiveNamespacesType() {
    }
    
    public String getPrefixList(){
        return this.prefixList;
    }
    
    public void addToPrefixList(String prefix){
        if(prefixList == null){
            prefixList = prefix;
        } else{
            prefixList = prefixList.concat(" ").concat(prefix);
        }
    }
    
}
