/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.junit.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import testutil.XmlUtil;

public class EprUtil
extends Assert {
    private static final String W3C_EPR_NS = "http://www.w3.org/2005/08/addressing";
    private static final String W3C_EPR_WSDLBINDING_NS = "http://www.w3.org/2006/05/addressing/wsdl";
    private static final String MS_EPR_NS = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    public static final QName WSDL_DEFINITIONS_NAME = new QName("http://schemas.xmlsoap.org/wsdl/", "definitions");
    private static final String W3C_EPR_METADATA_NS = "http://www.w3.org/2007/05/addressing/metadata";
    public static final String WSAM_WSDLI_ATTRIBUTE_NAMESPACE = "http://www.w3.org/ns/wsdl-instance";
    public static final String WSAM_WSDLI_ATTRIBUTE_LOCALNAME = "wsdlLocation";

    @Deprecated
    public static boolean validateEPR(Node node, Class<?> epr, String endpointAddress, QName serviceName, QName portName, QName portTypeName, boolean hasWSDL) {
        return EprUtil.validateEPR(node, epr, endpointAddress, serviceName, portName, portTypeName, hasWSDL, false, null);
    }

    public static boolean validateEPR(Node node, Class<?> epr, String endpointAddress, QName serviceName, QName portName, QName portTypeName, String wsdlLocation) {
        return EprUtil.validateEPR(node, epr, endpointAddress, serviceName, portName, portTypeName, wsdlLocation != null, false, wsdlLocation);
    }

    public static boolean validateEPR(Node node, Class<?> epr, String endpointAddress, QName serviceName, QName portName, QName portTypeName, String wsdlLocation, boolean useWsdlBindingNS) {
        return EprUtil.validateEPR(node, epr, endpointAddress, serviceName, portName, portTypeName, wsdlLocation != null, false, wsdlLocation);
    }

    private static boolean validateEPR(Node node, Class<?> epr, String endpointAddress, QName serviceName, QName portName, QName portTypeName, boolean hasWSDL, boolean useWsdlBindingNS, String wsdlLocation) {
        if (node.getNodeType() == 9) {
            node = node.getFirstChild();
        }
        if (epr.isAssignableFrom(W3CEndpointReference.class)) {
            Node portType;
            String ns;
            String name;
            String prefix;
            String qname;
            String W3C_EPR_WSDL_NS = useWsdlBindingNS ? W3C_EPR_WSDLBINDING_NS : W3C_EPR_METADATA_NS;
            EprUtil.assertTrue((node.getNamespaceURI().equals(W3C_EPR_NS) && node.getLocalName().equals("EndpointReference") ? 1 : 0) != 0);
            Element elm = (Element)node;
            Element add = XmlUtil.getFirstElementChild(node);
            String value = XmlUtil.getTextForNode(add);
            EprUtil.assertEquals((Object)value, (Object)endpointAddress);
            if (serviceName == null && portName == null && !hasWSDL) {
                return true;
            }
            NodeList nl = elm.getElementsByTagNameNS(W3C_EPR_NS, "Metadata");
            EprUtil.assertEquals((long)1L, (long)nl.getLength());
            Element metdata = (Element)nl.item(0);
            if (serviceName != null) {
                nl = metdata.getElementsByTagNameNS(W3C_EPR_WSDL_NS, "ServiceName");
                EprUtil.assertEquals((long)1L, (long)nl.getLength());
                Node service = nl.item(0);
                qname = XmlUtil.getTextForNode(service);
                prefix = XmlUtil.getPrefix(qname);
                name = XmlUtil.getLocalPart(qname);
                ns = service.lookupNamespaceURI(prefix);
                EprUtil.assertEquals((Object)ns, (Object)serviceName.getNamespaceURI());
                EprUtil.assertEquals((Object)name, (Object)serviceName.getLocalPart());
                if (portName != null) {
                    String port = ((Element)service).getAttribute("EndpointName");
                    EprUtil.assertEquals((Object)port, (Object)portName.getLocalPart());
                }
            }
            if (portTypeName != null) {
                nl = metdata.getElementsByTagNameNS(W3C_EPR_WSDL_NS, "InterfaceName");
                EprUtil.assertEquals((long)1L, (long)nl.getLength());
                portType = nl.item(0);
                qname = XmlUtil.getTextForNode(portType);
                prefix = XmlUtil.getPrefix(qname);
                name = XmlUtil.getLocalPart(qname);
                ns = portType.lookupNamespaceURI(prefix);
                EprUtil.assertEquals((Object)ns, (Object)portTypeName.getNamespaceURI());
                EprUtil.assertEquals((Object)name, (Object)portTypeName.getLocalPart());
            }
            if (hasWSDL) {
                if (useWsdlBindingNS) {
                    nl = metdata.getElementsByTagNameNS(WSDL_DEFINITIONS_NAME.getNamespaceURI(), WSDL_DEFINITIONS_NAME.getLocalPart());
                    EprUtil.assertTrue((nl.getLength() > 0 ? 1 : 0) != 0);
                    portType = nl.item(0);
                } else {
                    String wsdliLocation = metdata.getAttributeNS(WSAM_WSDLI_ATTRIBUTE_NAMESPACE, WSAM_WSDLI_ATTRIBUTE_LOCALNAME);
                    EprUtil.assertNotNull((Object)wsdliLocation);
                    String tns = wsdliLocation.substring(0, wsdliLocation.indexOf(32));
                    String wsdlAddress = wsdliLocation.substring(wsdliLocation.indexOf(32) + 1);
                    if (serviceName != null) {
                        EprUtil.assertEquals((Object)serviceName.getNamespaceURI(), (Object)tns);
                    }
                    if (wsdlAddress != null) {
                        EprUtil.assertEquals((Object)wsdlLocation, (Object)wsdlAddress);
                    }
                }
            }
            return true;
        }
        if (epr.isAssignableFrom(MemberSubmissionEndpointReference.class)) {
            String ns;
            String name;
            String prefix;
            String qname;
            NodeList nl;
            EprUtil.assertTrue((node.getNamespaceURI().equals(MS_EPR_NS) && node.getLocalName().equals("EndpointReference") ? 1 : 0) != 0);
            Element elm = (Element)node;
            Element add = XmlUtil.getFirstElementChild(node);
            String value = XmlUtil.getTextForNode(add);
            EprUtil.assertEquals((Object)value, (Object)endpointAddress);
            if (serviceName != null) {
                nl = elm.getElementsByTagNameNS(MS_EPR_NS, "ServiceName");
                EprUtil.assertEquals((long)1L, (long)nl.getLength());
                Node service = nl.item(0);
                qname = XmlUtil.getTextForNode(service);
                prefix = XmlUtil.getPrefix(qname);
                name = XmlUtil.getLocalPart(qname);
                ns = service.lookupNamespaceURI(prefix);
                EprUtil.assertEquals((Object)ns, (Object)serviceName.getNamespaceURI());
                EprUtil.assertEquals((Object)name, (Object)serviceName.getLocalPart());
                if (portName != null) {
                    String port = ((Element)service).getAttribute("PortName");
                    EprUtil.assertEquals((Object)port, (Object)portName.getLocalPart());
                }
            }
            if (hasWSDL) {
                nl = elm.getElementsByTagNameNS(MS_EPR_NS, "PortType");
                EprUtil.assertEquals((long)1L, (long)nl.getLength());
                Node portType = nl.item(0);
                qname = XmlUtil.getTextForNode(portType);
                prefix = XmlUtil.getPrefix(qname);
                name = XmlUtil.getLocalPart(qname);
                ns = portType.lookupNamespaceURI(prefix);
                EprUtil.assertEquals((Object)ns, (Object)portTypeName.getNamespaceURI());
                EprUtil.assertEquals((Object)name, (Object)portTypeName.getLocalPart());
            }
            if (hasWSDL) {
                nl = elm.getElementsByTagNameNS(WSDL_DEFINITIONS_NAME.getNamespaceURI(), WSDL_DEFINITIONS_NAME.getLocalPart());
                EprUtil.assertTrue((nl.getLength() > 0 ? 1 : 0) != 0);
                Node node2 = nl.item(0);
            }
            return true;
        }
        return false;
    }

    public static boolean validateEPR(EndpointReference epr, String endpointAddress, QName serviceName, QName portName, QName portTypeName, boolean hasWSDL) {
        EprUtil.assertNotNull((Object)epr);
        DOMResult dr = new DOMResult();
        epr.writeTo((Result)dr);
        Node node = dr.getNode();
        return EprUtil.validateEPR(node, epr.getClass(), endpointAddress, serviceName, portName, portTypeName, hasWSDL);
    }
}

