/*
 * Decompiled with CFR 0.152.
 */
package testutil.benchmark;

import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import testutil.benchmark.Benchmark;

public class BenchmarkTests {
    @Argument
    private List<String> tests = new ArrayList<String>();
    @Option(name="-l", usage="test the local transport")
    private boolean uselocal;
    private final PrintStream out = System.out;
    private XMLStreamWriter writer = null;
    private String version = "2.0";
    @Option(name="-p", usage="package name of the benchmark. either 'doclit' or 'rpclit'")
    private String testPackage = System.getProperty("package.prefix");
    @Option(name="-i", usage="number of iteration for the test")
    private int iterations = BenchmarkTests.getIntProperty("iterations", 100);
    @Option(name="-w", usage="number of iteration for the warm up")
    private int warmup = BenchmarkTests.getIntProperty("warmup", 100);
    private String state = System.getProperty("state", "first");
    private final String classPrefix = "Echo";
    private final String classSuffix = "Benchmark";
    private final String xmlLog = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "jaxrpc-benchmark.xml";
    private final String htmlLog = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "jaxrpc-benchmark.html";

    public static void main(String[] args) throws Exception {
        System.exit(new BenchmarkTests().run(args));
    }

    public BenchmarkTests() {
        String temp = System.getProperty("uselocal");
        this.uselocal = temp != null && temp.equals("true");
    }

    public int run(String[] args) throws Exception {
        CmdLineParser p = new CmdLineParser((Object)this);
        try {
            p.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println((Object)e);
            p.printUsage((OutputStream)System.err);
            return -1;
        }
        if (this.testPackage == null) {
            System.err.println("-p option is mandatory");
            return -1;
        }
        System.setProperty("uselocal", Boolean.toString(this.uselocal));
        boolean first = this.state.equalsIgnoreCase("first");
        FileOutputStream fos = new FileOutputStream(this.xmlLog, !first);
        this.writer = XMLStreamWriterFactory.create((OutputStream)fos, (String)"UTF-8");
        if (first) {
            this.writer.writeStartElement("benchmark");
            this.writeEnvironment(this.writer);
        }
        this.writer.writeStartElement(this.testPackage);
        this.writer.writeAttribute("jaxrpc-version", this.version);
        this.writer.writeAttribute("jdk-version", System.getProperty("java.vm.version"));
        if (this.tests.isEmpty()) {
            System.err.println("No test to run");
            return -1;
        }
        for (String test : this.tests) {
            this.invoke(test);
        }
        this.writer.writeEndElement();
        this.writer.close();
        fos.close();
        boolean last = this.state.equalsIgnoreCase("last");
        if (last) {
            fos = new FileOutputStream(this.xmlLog, true);
            fos.write("</benchmark>".getBytes());
            fos.flush();
            fos.close();
            this.out.println("******* XML log generated in \"" + this.xmlLog + "\"");
            this.convertToHTML();
        }
        return 0;
    }

    private void invoke(String classType) throws Exception {
        if ("\"\"".equals(classType)) {
            classType = "";
        }
        String className = "benchmark." + this.testPackage + ".client.Echo" + classType + "Benchmark";
        Class<?> classObject = Class.forName(className);
        Constructor<?> ctor = classObject.getConstructor(String.class);
        Benchmark benchmark = (Benchmark)ctor.newInstance(className);
        double returnValue = this.run(benchmark, this.out);
        this.out.println(className + " : " + returnValue + " ns");
        this.writer.writeStartElement("".equals(classType) ? "All" : classType);
        this.writer.writeCharacters(String.valueOf(returnValue));
        this.writer.writeEndElement();
        this.cleanup();
        this.out.println();
    }

    public long run(Benchmark benchmark, PrintStream out) throws Exception {
        System.out.println("Iterations: " + this.iterations);
        System.out.println("Warmup: " + this.warmup);
        for (int i = 0; i < this.warmup; ++i) {
            benchmark.testOnce();
        }
        this.cleanup();
        long startTime = System.nanoTime();
        for (int i = 0; i < this.iterations; ++i) {
            benchmark.testOnce();
        }
        long endTime = System.nanoTime();
        long totalTime = endTime - startTime;
        return totalTime / (long)this.iterations;
    }

    private void cleanup() throws InterruptedException {
        Runtime.getRuntime().gc();
        Thread.sleep(100L);
        Runtime.getRuntime().gc();
    }

    private void convertToHTML() throws TransformerException, IOException {
        StreamSource xslSource = new StreamSource(new File(System.getProperty("benchmark.stylesheet")));
        Transformer trans = TransformerFactory.newInstance().newTransformer(xslSource);
        Properties props = new Properties();
        props.put("omit-xml-declaration", "yes");
        trans.setOutputProperties(props);
        trans.transform(new StreamSource(new File(this.xmlLog)), new StreamResult(new FileOutputStream(this.htmlLog)));
        this.out.println("******* Benchmark results are available in \"" + this.htmlLog + "\"");
    }

    private void writeEnvironment(XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("environment");
        writer.writeStartElement("date");
        writer.writeCharacters(new Date().toString());
        writer.writeEndElement();
        writer.writeStartElement("os");
        writer.writeCharacters(System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        writer.writeEndElement();
        writer.writeStartElement("memory");
        writer.writeCharacters("" + Runtime.getRuntime().maxMemory());
        writer.writeEndElement();
        writer.writeStartElement("warmup");
        writer.writeCharacters(System.getProperty("warmup"));
        writer.writeEndElement();
        writer.writeStartElement("iterations");
        writer.writeCharacters(System.getProperty("iterations"));
        writer.writeEndElement();
        writer.writeStartElement("local-http");
        writer.writeCharacters(this.uselocal ? "Local" : "HTTP");
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static int getIntProperty(String key, int defaultValue) {
        if (System.getProperty(key) == null) {
            return defaultValue;
        }
        return Integer.valueOf(System.getProperty(key));
    }
}

