/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class NamespaceContextImpl
implements NamespaceContext {
    private static final Map<String, String> prefixToNSMap = new HashMap<String, String>();
    private static final Map<String, String> nsToPrefixMap = new HashMap<String, String>();

    public NamespaceContextImpl() {
        this.bindPrefixToNS("S11", "http://schemas.xmlsoap.org/soap/envelope/");
        this.bindPrefixToNS("S12", "http://www.w3.org/2003/05/soap-envelope");
        this.bindPrefixToNS("wsa", "http://www.w3.org/2005/08/addressing");
        this.bindPrefixToNS("wsa04", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
        this.bindPrefixToNS("ck", "http://example.org/customer");
    }

    public void bindPrefixToNS(String prefix, String namespaceURI) {
        prefixToNSMap.put(prefix, namespaceURI);
        nsToPrefixMap.put(namespaceURI, prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("NamespaceContextImpl#getNamespaceURI(String prefix) with prefix == null");
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (prefix.equals("")) {
            if (prefixToNSMap.containsKey(prefix)) {
                return prefixToNSMap.get(prefix);
            }
            return "";
        }
        if (prefixToNSMap.containsKey(prefix)) {
            return prefixToNSMap.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("NamespaceContextImpl#getPrefix(String namespaceURI) with namespaceURI == null");
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (nsToPrefixMap.containsKey(namespaceURI)) {
            return nsToPrefixMap.get(namespaceURI);
        }
        if (namespaceURI.equals("")) {
            return "";
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        return prefixToNSMap.keySet().iterator();
    }
}

