/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Node;
import testutil.W3CAddressingConstants;

public abstract class WsaBaseSOAPHandler
implements SOAPHandler<SOAPMessageContext> {
    String name;

    public boolean handleMessage(SOAPMessageContext context) {
        boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        try {
            String oper = this.getOperationName(this.getSOAPBody(context));
            if (outbound) {
                context.put((Object)"op.name", (Object)oper);
            } else if (this.getSOAPBody(context) != null && this.getSOAPBody(context).getFault() != null) {
                String detailName = this.getSOAPBody(context).getFault().getDetail().getFirstChild().getLocalName();
                this.checkFaultActions((String)context.get((Object)"op.name"), detailName, this.getAction(context));
            } else {
                this.checkInboundActions(oper, this.getAction(context));
            }
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return this.handleMessage(context);
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext messageContext) {
    }

    protected SOAPBody getSOAPBody(SOAPMessageContext context) throws SOAPException {
        return context.getMessage().getSOAPBody();
    }

    protected String getAction(SOAPMessageContext context) throws SOAPException {
        SOAPMessage message = context.getMessage();
        SOAPHeader header = message.getSOAPHeader();
        Iterator iter = header.getChildElements(this.getActionQName());
        if (!iter.hasNext()) {
            throw new WebServiceException("wsa:Action header is missing in the message");
        }
        Node node = (Node)iter.next();
        String action = node.getFirstChild().getNodeValue();
        return action;
    }

    protected String getOperationName(SOAPBody soapBody) throws SOAPException {
        if (soapBody == null) {
            return null;
        }
        if (soapBody.getFirstChild() == null) {
            return null;
        }
        return soapBody.getFirstChild().getLocalName();
    }

    protected void checkFaultActions(String requestName, String detailName, String action) {
    }

    public QName getActionQName() {
        return W3CAddressingConstants.actionTag;
    }

    protected abstract void checkInboundActions(String var1, String var2);
}

