/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.Init;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import org.jcp.xml.dsig.internal.dom.ApacheData;
import org.jcp.xml.dsig.internal.dom.ApacheNodeSetData;
import org.jcp.xml.dsig.internal.dom.ApacheOctetStreamData;
import org.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ApacheCanonicalizer
extends TransformService {
    private static Logger log;
    protected Canonicalizer apacheCanonicalizer;
    private Transform apacheTransform;
    protected String inclusiveNamespaces;
    protected C14NMethodParameterSpec params;
    protected Document ownerDoc;
    protected Element transformElem;

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public void init(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws InvalidAlgorithmParameterException {
        if (xMLCryptoContext != null && !(xMLCryptoContext instanceof DOMCryptoContext)) {
            throw new ClassCastException("context must be of type DOMCryptoContext");
        }
        this.transformElem = (Element)((DOMStructure)xMLStructure).getNode();
        this.ownerDoc = DOMUtils.getOwnerDocument(this.transformElem);
    }

    public void marshalParams(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws MarshalException {
        if (xMLCryptoContext != null && !(xMLCryptoContext instanceof DOMCryptoContext)) {
            throw new ClassCastException("context must be of type DOMCryptoContext");
        }
        this.transformElem = (Element)((DOMStructure)xMLStructure).getNode();
        this.ownerDoc = DOMUtils.getOwnerDocument(this.transformElem);
    }

    public Data canonicalize(Data data, XMLCryptoContext xMLCryptoContext) throws TransformException {
        return this.canonicalize(data, xMLCryptoContext, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Data canonicalize(Data data, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) throws TransformException {
        if (this.apacheCanonicalizer == null) {
            try {
                this.apacheCanonicalizer = Canonicalizer.getInstance(this.getAlgorithm());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Created canonicalizer for algorithm: " + this.getAlgorithm());
                }
            }
            catch (InvalidCanonicalizerException invalidCanonicalizerException) {
                throw new TransformException("Couldn't find Canonicalizer for: " + this.getAlgorithm() + ": " + invalidCanonicalizerException.getMessage(), invalidCanonicalizerException);
            }
        }
        if (outputStream != null) {
            this.apacheCanonicalizer.setWriter(outputStream);
        } else {
            this.apacheCanonicalizer.setWriter(new ByteArrayOutputStream());
        }
        try {
            Set set = null;
            if (data instanceof ApacheData) {
                XMLSignatureInput xMLSignatureInput = ((ApacheData)data).getXMLSignatureInput();
                if (xMLSignatureInput.isElement()) {
                    if (this.inclusiveNamespaces == null) return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalizeSubtree(xMLSignatureInput.getSubNode())));
                    return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalizeSubtree(xMLSignatureInput.getSubNode(), this.inclusiveNamespaces)));
                }
                if (!xMLSignatureInput.isNodeSet()) return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalize(Utils.readBytesFromStream(xMLSignatureInput.getOctetStream()))));
                set = xMLSignatureInput.getNodeSet();
            } else {
                if (data instanceof DOMSubTreeData) {
                    DOMSubTreeData dOMSubTreeData = (DOMSubTreeData)data;
                    if (this.inclusiveNamespaces == null) return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalizeSubtree(dOMSubTreeData.getRoot())));
                    return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalizeSubtree(dOMSubTreeData.getRoot(), this.inclusiveNamespaces)));
                }
                if (!(data instanceof NodeSetData)) return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalize(Utils.readBytesFromStream(((OctetStreamData)data).getOctetStream()))));
                NodeSetData nodeSetData = (NodeSetData)data;
                set = Utils.toNodeSet(nodeSetData.iterator());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Canonicalizing " + set.size() + " nodes");
                }
            }
            if (this.inclusiveNamespaces == null) return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalizeXPathNodeSet(set)));
            return new OctetStreamData(new ByteArrayInputStream(this.apacheCanonicalizer.canonicalizeXPathNodeSet(set, this.inclusiveNamespaces)));
        }
        catch (Exception exception) {
            throw new TransformException(exception);
        }
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) throws TransformException {
        XMLSignatureInput xMLSignatureInput;
        if (data == null) {
            throw new NullPointerException("data must not be null");
        }
        if (outputStream == null) {
            throw new NullPointerException("output stream must not be null");
        }
        if (this.ownerDoc == null) {
            throw new TransformException("transform must be marshalled");
        }
        if (this.apacheTransform == null) {
            try {
                this.apacheTransform = Transform.getInstance((Document)this.ownerDoc, (String)this.getAlgorithm(), (NodeList)this.transformElem.getChildNodes());
                this.apacheTransform.setElement(this.transformElem, xMLCryptoContext.getBaseURI());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Created transform for algorithm: " + this.getAlgorithm());
                }
            }
            catch (Exception exception) {
                throw new TransformException("Couldn't find Transform for: " + this.getAlgorithm(), exception);
            }
        }
        if (data instanceof ApacheData) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "ApacheData = true");
            }
            xMLSignatureInput = ((ApacheData)data).getXMLSignatureInput();
        } else if (data instanceof NodeSetData) {
            Iterable iterable;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "isNodeSet() = true");
            }
            if (data instanceof DOMSubTreeData) {
                iterable = (DOMSubTreeData)data;
                xMLSignatureInput = new XMLSignatureInput(((DOMSubTreeData)iterable).getRoot());
                xMLSignatureInput.setExcludeComments(((DOMSubTreeData)iterable).excludeComments());
            } else {
                iterable = Utils.toNodeSet(((NodeSetData)data).iterator());
                xMLSignatureInput = new XMLSignatureInput((Set<Node>)iterable);
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "isNodeSet() = false");
            }
            try {
                xMLSignatureInput = new XMLSignatureInput(((OctetStreamData)data).getOctetStream());
            }
            catch (Exception exception) {
                throw new TransformException(exception);
            }
        }
        try {
            xMLSignatureInput = this.apacheTransform.performTransform(xMLSignatureInput, outputStream);
            if (!xMLSignatureInput.isNodeSet() && !xMLSignatureInput.isElement()) {
                return null;
            }
            if (xMLSignatureInput.isOctetStream()) {
                return new ApacheOctetStreamData(xMLSignatureInput);
            }
            return new ApacheNodeSetData(xMLSignatureInput);
        }
        catch (Exception exception) {
            throw new TransformException(exception);
        }
    }

    public final boolean isFeatureSupported(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return false;
    }

    static {
        Init.init();
        log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    }
}

