/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SubjectName;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509SubjectNameResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(X509SubjectNameResolver.class.getName());

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineLookupResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        log.log(Level.FINE, "Can I resolve " + element.getTagName() + "?");
        Element[] elementArray = null;
        XMLX509SubjectName[] xMLX509SubjectNameArray = null;
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            log.log(Level.FINE, "I can't");
            return null;
        }
        elementArray = XMLUtils.selectDsNodes(element.getFirstChild(), "X509SubjectName");
        if (elementArray == null || elementArray.length <= 0) {
            log.log(Level.FINE, "I can't");
            return null;
        }
        try {
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509SubjectName"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                log.log(Level.INFO, "", keyResolverException);
                throw keyResolverException;
            }
            xMLX509SubjectNameArray = new XMLX509SubjectName[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                xMLX509SubjectNameArray[i] = new XMLX509SubjectName(elementArray[i], string);
            }
            while (storageResolver.hasNext()) {
                X509Certificate x509Certificate = storageResolver.next();
                XMLX509SubjectName xMLX509SubjectName = new XMLX509SubjectName(element.getOwnerDocument(), x509Certificate);
                log.log(Level.FINE, "Found Certificate SN: " + xMLX509SubjectName.getSubjectName());
                for (int i = 0; i < xMLX509SubjectNameArray.length; ++i) {
                    log.log(Level.FINE, "Found Element SN:     " + xMLX509SubjectNameArray[i].getSubjectName());
                    if (xMLX509SubjectName.equals(xMLX509SubjectNameArray[i])) {
                        log.log(Level.FINE, "match !!! ");
                        return x509Certificate;
                    }
                    log.log(Level.FINE, "no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

