/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.xml.rpc.processor.config;

/**
 *
 * @author JAX-RPC Development Team
 */
public class ImportedDocumentInfo {

    public static final int UNKNOWN_DOCUMENT = 0;
    public static final int SCHEMA_DOCUMENT = 1;
    public static final int WSDL_DOCUMENT = 2;

    public ImportedDocumentInfo() {}
    
    public ImportedDocumentInfo(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }
    
    public void setType(int i) {
        type = i;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String s) {
        namespace = s;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String s) {
        location = s;
    }

    private int type;
    private String namespace;
    private String location;
}
