/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.types;

import com.sun.xml.fastinfoset.types.ValueInstance;
import com.sun.xml.fastinfoset.types.XSDataType;
import java.util.Set;

public class LexicalSpaceConvertor {
    private LexicalSpaceConvertor() {
    }

    public static Object convertToValueSpace(Set<XSDataType> types, String s, LexicalPreference preference) {
        return LexicalSpaceConvertor.convertToValueSpace(types, s.toCharArray(), 0, s.length(), preference);
    }

    public static Object convertToValueSpace(Set<XSDataType> types, char[] ch, int start, int length, LexicalPreference preference) {
        if (types == null) {
            return null;
        }
        for (XSDataType dt : types) {
            try {
                if (dt.encodingAlgorithm != null) {
                    boolean[] b;
                    Object value = dt.encodingAlgorithm.convertFromCharacters(ch, start, length);
                    if (dt == XSDataType.BOOLEAN && (b = (boolean[])value).length == 1) {
                        String s = new String(ch, start, length).trim();
                        if (s.equalsIgnoreCase("true")) {
                            return preference == LexicalPreference.string ? "1" : (Object)"1".toCharArray();
                        }
                        if (s.equalsIgnoreCase("false")) {
                            return preference == LexicalPreference.string ? "0" : (Object)"0".toCharArray();
                        }
                        return null;
                    }
                    return new ValueInstance(dt.encodingAlgorithmId, value);
                }
                if (dt.alphabet != null) {
                    Object object;
                    if ((ch = LexicalSpaceConvertor.validateCharactersWithAlphabet(dt.alphabet, ch, start, length)) != null && ch.length > 2) {
                        return preference == LexicalPreference.string ? new ValueInstance(dt.alphabet, (Object)new String(ch)) : new ValueInstance(dt.alphabet, (Object)ch);
                    }
                    if (preference == LexicalPreference.string) {
                        String string;
                        object = string;
                        string = new String(ch);
                    } else {
                        object = ch;
                    }
                    return object;
                }
                if (dt != XSDataType.ANYURI) continue;
                return preference == LexicalPreference.string ? new ValueInstance(new String(ch, start, length)) : new ValueInstance(new String(ch, start, length).toCharArray());
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static char[] validateCharactersWithAlphabet(String alphabet, char[] ch, int start, int length) {
        for (char c : ch = new String(ch, start, length).trim().toCharArray()) {
            if (alphabet.indexOf(c) != -1) continue;
            return null;
        }
        return ch;
    }

    public static enum LexicalPreference {
        string,
        charArray;

    }
}

