/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.analysis.frequency;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class FrequencySet<T>
extends HashMap<T, Integer> {
    private static final long serialVersionUID = 3211015452350934703L;

    public FrequencySet(int initialCapacity) {
        super(initialCapacity);
    }

    public FrequencySet() {
    }

    public void add(T value) {
        this._add(value, 1);
    }

    public void add0(T value) {
        this._add(value, 0);
    }

    private void _add(T value, int v) {
        Integer f = (Integer)this.get(value);
        f = f == null ? v : f + 1;
        this.put(value, f);
    }

    public List<T> createFrequencyBasedList() {
        TreeSet s = new TreeSet(new FrequencyComparator());
        s.addAll(this.entrySet());
        ArrayList l = new ArrayList();
        for (Map.Entry entry : s) {
            l.add(entry.getKey());
        }
        return Collections.unmodifiableList(l);
    }

    public Set<T> createFrequencyBasedSet() {
        TreeSet s = new TreeSet(new FrequencyComparator());
        s.addAll(this.entrySet());
        LinkedHashSet l = new LinkedHashSet();
        for (Map.Entry entry : s) {
            l.add(entry.getKey());
        }
        return Collections.unmodifiableSet(l);
    }

    private class FrequencyComparator
    implements Comparator<Map.Entry<T, Integer>> {
        private FrequencyComparator() {
        }

        @Override
        public int compare(Map.Entry<T, Integer> e1, Map.Entry<T, Integer> e2) {
            int diff = e2.getValue() - e1.getValue();
            if (diff == 0) {
                if (e1.getKey().equals(e2.getKey())) {
                    return 0;
                }
                return 1;
            }
            return diff;
        }
    }
}

