/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.comm;

import com.sun.btrace.aggregation.HistogramData;
import com.sun.btrace.comm.DataCommand;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class GridDataCommand
extends DataCommand {
    private static final Pattern INDEX_PATTERN = Pattern.compile("%(\\d)+\\$");
    private List<Object[]> data;
    private String format;
    private static final HashMap<Class<?>, String> typeFormats = new HashMap();

    public GridDataCommand() {
        this(null, null);
    }

    public GridDataCommand(String name, List<Object[]> data) {
        this(name, data, null);
    }

    public GridDataCommand(String name, List<Object[]> data, String format) {
        super((byte)10, name);
        this.data = data;
        this.format = format;
    }

    public List<Object[]> getData() {
        return this.data;
    }

    @Override
    public void print(PrintWriter out) {
        if (this.data != null) {
            if (this.name != null && !this.name.equals("")) {
                out.println(this.name);
            }
            for (Object[] dataRow : this.data) {
                Appendable buffer;
                Object[] printRow = (Object[])dataRow.clone();
                for (int i = 0; i < printRow.length; ++i) {
                    String value;
                    if (printRow[i] == null) {
                        printRow[i] = "<null>";
                    }
                    if (printRow[i] instanceof HistogramData) {
                        buffer = new StringWriter();
                        PrintWriter writer = new PrintWriter((Writer)buffer);
                        ((HistogramData)printRow[i]).print(writer);
                        writer.flush();
                        printRow[i] = ((StringWriter)buffer).toString();
                    }
                    if (!(printRow[i] instanceof String) || !(value = (String)printRow[i]).contains("\n")) continue;
                    printRow[i] = this.reformatMultilineValue(value);
                }
                String usedFormat = this.format;
                if (usedFormat == null || usedFormat.length() == 0) {
                    buffer = new StringBuilder();
                    for (int i = 0; i < printRow.length; ++i) {
                        ((StringBuilder)buffer).append("  ");
                        ((StringBuilder)buffer).append(this.getFormat(printRow[i]));
                    }
                    usedFormat = ((StringBuilder)buffer).toString();
                }
                String line = String.format(usedFormat, printRow);
                out.println(line);
            }
        }
    }

    private String getFormat(Object object) {
        if (object == null) {
            return "%15s";
        }
        String usedFormat = typeFormats.get(object.getClass());
        if (usedFormat == null) {
            return "%15s";
        }
        return usedFormat;
    }

    private String reformatMultilineValue(String value) {
        StringBuilder result = new StringBuilder();
        result.append("\n");
        for (String line : value.split("\n")) {
            result.append("\t").append(line);
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    protected void write(ObjectOutput out) throws IOException {
        out.writeUTF(this.name != null ? this.name : "");
        if (this.data != null) {
            out.writeUTF(this.format != null ? this.format : "");
            out.writeInt(this.data.size());
            for (Object[] row : this.data) {
                out.writeInt(row.length);
                for (Object cell : row) {
                    out.writeObject(cell);
                }
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    protected void read(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.format = in.readUTF();
        if (this.format.length() == 0) {
            this.format = null;
        }
        int rowCount = in.readInt();
        this.data = new ArrayList<Object[]>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            int cellCount = in.readInt();
            Object[] row = new Object[cellCount];
            for (int j = 0; j < cellCount; ++j) {
                row[j] = in.readObject();
            }
            this.data.add(row);
        }
    }

    static {
        typeFormats.put(Integer.class, "%15d");
        typeFormats.put(Short.class, "%15d");
        typeFormats.put(Byte.class, "%15d");
        typeFormats.put(Long.class, "%15d");
        typeFormats.put(BigInteger.class, "%15d");
        typeFormats.put(Double.class, "%15f");
        typeFormats.put(Float.class, "%15f");
        typeFormats.put(BigDecimal.class, "%15f");
        typeFormats.put(String.class, "%50s");
    }
}

