/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.atomserver.resources;

import com.sun.jersey.samples.atomserver.resources.AtomStore;
import com.sun.jersey.samples.atomserver.resources.FileStore;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Consumes(value={"application/atom+xml"})
@Produces(value={"application/atom+xml"})
public class EntryResource {
    protected String entryId;
    protected String entryPath;

    public EntryResource(String entryId) {
        this.entryId = entryId;
        this.entryPath = AtomStore.getEntryPath(entryId);
        AtomStore.checkExistence(this.entryPath);
    }

    @GET
    public InputStream getEntry() {
        return FileStore.FS.getFileContents(this.entryPath);
    }

    @GET
    @Path(value="media")
    @Produces(value={"*/*"})
    public Response getMedia() {
        String mediaPath = AtomStore.getMediaPath(this.entryId);
        AtomStore.checkExistence(mediaPath);
        InputStream in = FileStore.FS.getFileContents(mediaPath);
        return Response.ok((Object)in).build();
    }
}

