/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework.spi.container.external;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.WebAppDescriptor;
import com.sun.jersey.test.framework.spi.container.TestContainer;
import com.sun.jersey.test.framework.spi.container.TestContainerFactory;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalTestContainerFactory
implements TestContainerFactory {
    public Class<WebAppDescriptor> supports() {
        return WebAppDescriptor.class;
    }

    @Override
    public TestContainer create(URI baseUri, AppDescriptor ad) {
        if (!(ad instanceof WebAppDescriptor)) {
            throw new IllegalArgumentException("The application descriptor must be an instance of WebAppDescriptor");
        }
        return new ExternalTestContainer(this.getBaseURI(baseUri), (WebAppDescriptor)ad);
    }

    private URI getBaseURI(URI baseUri) {
        String stagingHostName = System.getProperty("JERSEY_HOST_NAME");
        if (stagingHostName != null) {
            return UriBuilder.fromUri((URI)baseUri).host(stagingHostName).build(new Object[0]);
        }
        return baseUri;
    }

    private static class ExternalTestContainer
    implements TestContainer {
        final URI baseUri;

        private ExternalTestContainer(URI baseUri, WebAppDescriptor ad) {
            this.baseUri = UriBuilder.fromUri((URI)baseUri).path(ad.getContextPath()).path(ad.getServletPath()).build(new Object[0]);
        }

        public Client getClient() {
            return null;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

