/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.LowLevelAppDescriptor;
import com.sun.jersey.test.framework.WebAppDescriptor;
import com.sun.jersey.test.framework.spi.container.TestContainer;
import com.sun.jersey.test.framework.spi.container.TestContainerException;
import com.sun.jersey.test.framework.spi.container.TestContainerFactory;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.junit.After;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JerseyTest {
    private static Class<? extends TestContainerFactory> defaultTestContainerFactoryClass;
    private TestContainerFactory testContainerFactory;
    private final TestContainer tc;
    private final Client client;
    private static final String DEFAULT_TEST_CONTAINER_FACTORY_CLASS_NAME = "com.sun.jersey.test.framework.spi.container.grizzly.web.GrizzlyWebTestContainerFactory";

    public JerseyTest() throws TestContainerException {
        AppDescriptor ad = this.configure();
        this.tc = JerseyTest.getContainer(ad, this.getTestContainerFactory());
        this.client = JerseyTest.getClient(this.tc, ad);
    }

    public JerseyTest(TestContainerFactory testContainerFactory) {
        this.setTestContainerFactory(testContainerFactory);
        AppDescriptor ad = this.configure();
        this.tc = JerseyTest.getContainer(ad, this.getTestContainerFactory());
        this.client = JerseyTest.getClient(this.tc, ad);
    }

    protected AppDescriptor configure() {
        throw new UnsupportedOperationException("The configure method must be implemented by the extending class");
    }

    public JerseyTest(AppDescriptor ad) throws TestContainerException {
        this.tc = JerseyTest.getContainer(ad, this.getTestContainerFactory());
        this.client = JerseyTest.getClient(this.tc, ad);
    }

    public JerseyTest(String ... packages) throws TestContainerException {
        this(new WebAppDescriptor.Builder(packages).build());
    }

    protected void setTestContainerFactory(TestContainerFactory testContainerFactory) {
        this.testContainerFactory = testContainerFactory;
    }

    protected TestContainerFactory getTestContainerFactory() throws TestContainerException {
        if (this.testContainerFactory == null) {
            this.testContainerFactory = JerseyTest.getDefaultTestContainerFactory();
        }
        return this.testContainerFactory;
    }

    public WebResource resource() {
        return this.client.resource(this.tc.getBaseUri());
    }

    public Client client() {
        return this.client;
    }

    @Before
    public void setUp() throws Exception {
        this.tc.start();
    }

    @After
    public void tearDown() throws Exception {
        this.tc.stop();
    }

    private static TestContainer getContainer(AppDescriptor ad, TestContainerFactory tcf) {
        if (ad == null) {
            throw new IllegalArgumentException("The application descriptor cannot be null");
        }
        Class adType = tcf.supports();
        if (adType == LowLevelAppDescriptor.class && ad.getClass() == WebAppDescriptor.class) {
            ad = LowLevelAppDescriptor.transform((WebAppDescriptor)ad);
        } else if (adType != ad.getClass()) {
            throw new TestContainerException("The application descriptor type, " + ad.getClass() + ", is not supported by the test container factory, " + tcf);
        }
        return tcf.create(JerseyTest.getBaseURI(), ad);
    }

    private static TestContainerFactory getDefaultTestContainerFactory() {
        if (defaultTestContainerFactoryClass == null) {
            defaultTestContainerFactoryClass = JerseyTest.getDefaultTestContainerFactoryClass();
        }
        try {
            return defaultTestContainerFactoryClass.newInstance();
        }
        catch (Exception ex) {
            throw new TestContainerException("The default test container factory, " + defaultTestContainerFactoryClass + ", could not be instantiated", ex);
        }
    }

    private static Class<? extends TestContainerFactory> getDefaultTestContainerFactoryClass() {
        String tcfClassName = System.getProperty("test.containerFactory", DEFAULT_TEST_CONTAINER_FACTORY_CLASS_NAME);
        try {
            return Class.forName(tcfClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new TestContainerException("The default test container factory class name, " + tcfClassName + ", cannot be loaded", ex);
        }
        catch (ClassCastException ex) {
            throw new TestContainerException("The default test container factory class, " + tcfClassName + ", is not an instance of TestContainerFactory", ex);
        }
    }

    private static Client getClient(TestContainer tc, AppDescriptor ad) {
        boolean enableLogging;
        Client c = tc.getClient();
        if (c != null) {
            return c;
        }
        c = Client.create((ClientConfig)ad.getClientConfig());
        boolean bl = enableLogging = System.getProperty("enableLogging") != null;
        if (enableLogging) {
            c.addFilter((ClientFilter)new LoggingFilter());
        }
        return c;
    }

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/").port(JerseyTest.getPort(9998)).build(new Object[0]);
    }

    private static int getPort(int defaultPort) {
        String port = System.getProperty("JERSEY_HTTP_PORT");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultPort;
    }
}

