/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.wadl;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.server.impl.model.method.ResourceHttpOptionsMethod;
import com.sun.jersey.server.impl.model.method.ResourceMethod;
import com.sun.jersey.server.wadl.WadlApplicationContext;
import com.sun.jersey.server.wadl.WadlBuilder;
import com.sun.jersey.server.wadl.WadlGenerator;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

final class WadlMethodFactory {
    WadlMethodFactory() {
    }

    private static Application generateApplication(UriInfo info, AbstractResource resource, String path, WadlGenerator wadlGenerator) {
        Application a = path == null ? new WadlBuilder(wadlGenerator).generate(resource) : new WadlBuilder(wadlGenerator).generate(resource, path);
        for (Resources resources : a.getResources()) {
            resources.setBase(info.getBaseUri().toString());
        }
        for (Resources resources : a.getResources()) {
            Resource r = resources.getResource().get(0);
            r.setPath(info.getBaseUri().relativize(info.getAbsolutePath()).toString());
            r.getParam().clear();
        }
        return a;
    }

    private static final class WadlOptionsMethodDispatcher
    extends ResourceHttpOptionsMethod.OptionsRequestDispatcher {
        private final AbstractResource resource;
        private final String path;
        private final WadlGenerator wadlGenerator;
        private final WadlApplicationContext wadlApplicationContext;

        WadlOptionsMethodDispatcher(Map<String, List<ResourceMethod>> methods, AbstractResource resource, String path, WadlGenerator wadlGenerator, WadlApplicationContext wadlApplicationContext) {
            super(methods);
            this.resource = resource;
            this.path = path;
            this.wadlGenerator = wadlGenerator;
            this.wadlApplicationContext = wadlApplicationContext;
        }

        @Override
        public void dispatch(Object o, HttpContext context) {
            if (this.wadlApplicationContext.isWadlGenerationEnabled()) {
                Application a = WadlMethodFactory.generateApplication(context.getUriInfo(), this.resource, this.path, this.wadlGenerator);
                context.getResponse().setResponse(Response.ok((Object)a, (MediaType)MediaTypes.WADL).header("Allow", (Object)this.allow).build());
            } else if (!this.wadlApplicationContext.isWadlGenerationEnabled()) {
                context.getResponse().setResponse(Response.status((Response.Status)Response.Status.NO_CONTENT).header("Allow", (Object)this.allow).build());
            }
        }
    }

    public static final class WadlOptionsMethod
    extends ResourceMethod {
        public WadlOptionsMethod(Map<String, List<ResourceMethod>> methods, AbstractResource resource, String path, WadlGenerator wadlGenerator, WadlApplicationContext wadlApplicationContext) {
            super("OPTIONS", UriTemplate.EMPTY, MediaTypes.GENERAL_MEDIA_TYPE_LIST, MediaTypes.GENERAL_MEDIA_TYPE_LIST, false, new WadlOptionsMethodDispatcher(methods, resource, path, wadlGenerator, wadlApplicationContext));
        }

        public String toString() {
            return "WADL OPTIONS method";
        }
    }
}

