/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.parameter.multivalued;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.server.impl.model.parameter.multivalued.ExtractorContainerException;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import com.sun.jersey.spi.StringReader;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;

final class StringReaderExtractor
implements MultivaluedParameterExtractor {
    private final StringReader sr;
    private final String parameter;
    private final String defaultStringValue;

    public StringReaderExtractor(StringReader sr, String parameter, String defaultStringValue) {
        this.sr = sr;
        this.parameter = parameter;
        this.defaultStringValue = defaultStringValue;
        Object defaultValue = defaultStringValue != null ? sr.fromString(defaultStringValue) : null;
    }

    @Override
    public String getName() {
        return this.parameter;
    }

    @Override
    public String getDefaultStringValue() {
        return this.defaultStringValue;
    }

    @Override
    public Object extract(MultivaluedMap<String, String> parameters) {
        String v = (String)parameters.getFirst((Object)this.parameter);
        if (v != null) {
            try {
                return this.sr.fromString(v);
            }
            catch (WebApplicationException ex) {
                throw ex;
            }
            catch (ContainerException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExtractorContainerException(ex);
            }
        }
        if (this.defaultStringValue != null) {
            return this.sr.fromString(this.defaultStringValue);
        }
        return null;
    }
}

