/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.template;

import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.impl.template.ResolvedViewable;
import com.sun.jersey.spi.template.TemplateContext;
import com.sun.jersey.spi.template.TemplateProcessor;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import java.net.URI;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewableRule
implements UriRule {
    @Context
    TemplateContext tc;

    @Override
    public final boolean accept(CharSequence path, Object resource, UriRuleContext context) {
        HttpRequestContext request = context.getRequest();
        if (!request.getMethod().equals("GET")) {
            return false;
        }
        String templatePath = path.length() > 0 ? context.getMatchResult().group(1) : "";
        String absoluteTemplatePath = this.getAbsolutePath(resource.getClass(), templatePath);
        for (TemplateProcessor t : this.tc.getTemplateProcessors()) {
            String resolvedPath = t.resolve(absoluteTemplatePath);
            if (resolvedPath == null) continue;
            HttpResponseContext response = context.getResponse();
            response.setResponse(Response.ok((Object)new ResolvedViewable(t, resolvedPath, resource)).build());
            return true;
        }
        return false;
    }

    private String getAbsolutePath(Class<?> resourceClass, String path) {
        if (path == null || path.length() == 0 || path.equals("/")) {
            path = "index";
        } else if (path.startsWith("/")) {
            return path;
        }
        return this.getAbsolutePath(resourceClass) + '/' + path;
    }

    private String getAbsolutePath(Class<?> resourceClass) {
        return "/" + resourceClass.getName().replace('.', '/').replace('$', '/');
    }

    private boolean redirect(UriRuleContext context) {
        HttpResponseContext response = context.getResponse();
        response.setResponse(Response.temporaryRedirect((URI)UriBuilder.fromUri((URI)context.getUriInfo().getAbsolutePath()).path("/").build(new Object[0])).build());
        return true;
    }
}

