/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.PartialRequestBuilder;
import com.sun.jersey.api.client.RequestBuilder;
import com.sun.jersey.api.client.UniformInterface;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.filter.Filterable;
import com.sun.jersey.impl.client.ClientRequestImpl;
import java.net.URI;
import java.util.Locale;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebResource
extends Filterable
implements RequestBuilder<Builder>,
UniformInterface {
    private final URI u;

    WebResource(ClientHandler c, URI u) {
        super(c);
        this.u = u;
    }

    private WebResource(WebResource that, UriBuilder ub) {
        super(that);
        this.u = ub.build(new Object[0]);
    }

    public URI getURI() {
        return this.u;
    }

    public UriBuilder getBuilder() {
        return UriBuilder.fromUri((URI)this.u);
    }

    @Override
    public ClientResponse head() {
        return this.getHeadHandler().handle(new ClientRequestImpl(this.getURI(), "HEAD"));
    }

    @Override
    public <T> T options(Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    @Override
    public <T> T options(GenericType<T> gt) {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    @Override
    public <T> T get(Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    @Override
    public <T> T get(GenericType<T> gt) {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    @Override
    public void put() {
        this.voidHandle(new ClientRequestImpl(this.getURI(), "PUT", null));
    }

    @Override
    public void put(Object requestEntity) {
        this.voidHandle(new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    @Override
    public <T> T put(Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    @Override
    public <T> T put(GenericType<T> gt) {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    @Override
    public <T> T put(Class<T> c, Object requestEntity) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    @Override
    public <T> T put(GenericType<T> gt, Object requestEntity) {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    @Override
    public void post() {
        this.voidHandle(new ClientRequestImpl(this.getURI(), "POST"));
    }

    @Override
    public void post(Object requestEntity) {
        this.voidHandle(new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    @Override
    public <T> T post(Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    @Override
    public <T> T post(GenericType<T> gt) {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    @Override
    public <T> T post(Class<T> c, Object requestEntity) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    @Override
    public <T> T post(GenericType<T> gt, Object requestEntity) {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    @Override
    public void delete() {
        this.voidHandle(new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    @Override
    public void delete(Object requestEntity) {
        this.voidHandle(new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    @Override
    public <T> T delete(Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    @Override
    public <T> T delete(GenericType<T> gt) {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    @Override
    public <T> T delete(Class<T> c, Object requestEntity) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    @Override
    public <T> T delete(GenericType<T> gt, Object requestEntity) {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    @Override
    public void method(String method) {
        this.voidHandle(new ClientRequestImpl(this.getURI(), method));
    }

    @Override
    public void method(String method, Object requestEntity) {
        this.voidHandle(new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    @Override
    public <T> T method(String method, Class<T> c) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    @Override
    public <T> T method(String method, GenericType<T> gt) {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    @Override
    public <T> T method(String method, Class<T> c, Object requestEntity) {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    @Override
    public <T> T method(String method, GenericType<T> gt, Object requestEntity) {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    @Override
    public Builder entity(Object entity) {
        return (Builder)new Builder(this.getURI()).entity(entity);
    }

    @Override
    public Builder entity(Object entity, MediaType type) {
        return (Builder)new Builder(this.getURI()).entity(entity, type);
    }

    @Override
    public Builder entity(Object entity, String type) {
        return (Builder)new Builder(this.getURI()).entity(entity, type);
    }

    @Override
    public Builder type(MediaType type) {
        return (Builder)new Builder(this.getURI()).type(type);
    }

    @Override
    public Builder type(String type) {
        return (Builder)new Builder(this.getURI()).type(type);
    }

    @Override
    public Builder accept(MediaType ... types) {
        return (Builder)new Builder(this.getURI()).accept(types);
    }

    @Override
    public Builder accept(String ... types) {
        return (Builder)new Builder(this.getURI()).accept(types);
    }

    @Override
    public Builder acceptLanguage(Locale ... locales) {
        return (Builder)new Builder(this.getURI()).acceptLanguage(locales);
    }

    @Override
    public Builder acceptLanguage(String ... locales) {
        return (Builder)new Builder(this.getURI()).acceptLanguage(locales);
    }

    @Override
    public Builder cookie(Cookie cookie) {
        return (Builder)new Builder(this.getURI()).cookie(cookie);
    }

    @Override
    public Builder header(String name, Object value) {
        return (Builder)new Builder(this.getURI()).header(name, value);
    }

    public WebResource path(String path) {
        return new WebResource(this, this.getBuilder().path(path));
    }

    public WebResource uri(URI uri) {
        String query;
        UriBuilder b = this.getBuilder();
        String path = uri.getRawPath();
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                b.replacePath(path);
            } else {
                b.path(path);
            }
        }
        if ((query = uri.getRawQuery()) != null && query.length() > 0) {
            b.replaceQuery(query);
        }
        return new WebResource(this, b);
    }

    private <T> T handle(Class<T> c, ClientRequest ro) {
        ClientResponse r = this.getHeadHandler().handle(ro);
        if (c == ClientResponse.class) {
            return c.cast(r);
        }
        if (r.getStatus() < 300) {
            return r.getEntity(c);
        }
        throw new UniformInterfaceException("Status: " + r.getStatus(), r);
    }

    private <T> T handle(GenericType<T> gt, ClientRequest ro) {
        ClientResponse r = this.getHeadHandler().handle(ro);
        if (gt.getRawClass() == ClientResponse.class) {
            gt.getRawClass().cast(r);
        }
        if (r.getStatus() < 300) {
            return r.getEntity(gt);
        }
        throw new UniformInterfaceException("Status: " + r.getStatus(), r);
    }

    private void voidHandle(ClientRequest ro) {
        ClientResponse r = this.getHeadHandler().handle(ro);
        if (r.getStatus() >= 300) {
            throw new UniformInterfaceException("Status: " + r.getStatus(), r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Builder
    extends PartialRequestBuilder<Builder>
    implements UniformInterface {
        private final URI u;

        private Builder(URI u) {
            this.u = u;
        }

        private ClientRequest build(String method) {
            ClientRequestImpl ro = new ClientRequestImpl(this.u, method, this.entity, (MultivaluedMap<String, Object>)this.metadata);
            this.entity = null;
            this.metadata = null;
            return ro;
        }

        private ClientRequest build(String method, Object e) {
            ClientRequestImpl ro = new ClientRequestImpl(this.u, method, e, (MultivaluedMap<String, Object>)this.metadata);
            this.entity = null;
            this.metadata = null;
            return ro;
        }

        @Override
        public ClientResponse head() {
            return WebResource.this.getHeadHandler().handle(this.build("HEAD"));
        }

        @Override
        public <T> T options(Class<T> c) {
            return (T)WebResource.this.handle(c, this.build("OPTIONS"));
        }

        @Override
        public <T> T options(GenericType<T> gt) {
            return (T)WebResource.this.handle(gt, this.build("OPTIONS"));
        }

        @Override
        public <T> T get(Class<T> c) {
            return (T)WebResource.this.handle(c, this.build("GET"));
        }

        @Override
        public <T> T get(GenericType<T> gt) {
            return (T)WebResource.this.handle(gt, this.build("GET"));
        }

        @Override
        public void put() {
            WebResource.this.voidHandle(this.build("PUT"));
        }

        @Override
        public void put(Object requestEntity) {
            WebResource.this.voidHandle(this.build("PUT", requestEntity));
        }

        @Override
        public <T> T put(Class<T> c) {
            return (T)WebResource.this.handle(c, this.build("PUT"));
        }

        @Override
        public <T> T put(GenericType<T> gt) {
            return (T)WebResource.this.handle(gt, this.build("PUT"));
        }

        @Override
        public <T> T put(Class<T> c, Object requestEntity) {
            return (T)WebResource.this.handle(c, this.build("PUT", requestEntity));
        }

        @Override
        public <T> T put(GenericType<T> gt, Object requestEntity) {
            return (T)WebResource.this.handle(gt, this.build("PUT", requestEntity));
        }

        @Override
        public void post() {
            WebResource.this.voidHandle(this.build("POST"));
        }

        @Override
        public void post(Object requestEntity) {
            WebResource.this.voidHandle(this.build("POST", requestEntity));
        }

        @Override
        public <T> T post(Class<T> c) {
            return (T)WebResource.this.handle(c, this.build("POST"));
        }

        @Override
        public <T> T post(GenericType<T> gt) {
            return (T)WebResource.this.handle(gt, this.build("POST"));
        }

        @Override
        public <T> T post(Class<T> c, Object requestEntity) {
            return (T)WebResource.this.handle(c, this.build("POST", requestEntity));
        }

        @Override
        public <T> T post(GenericType<T> gt, Object requestEntity) {
            return (T)WebResource.this.handle(gt, this.build("POST", requestEntity));
        }

        @Override
        public void delete() {
            WebResource.this.voidHandle(this.build("DELETE"));
        }

        @Override
        public void delete(Object requestEntity) {
            WebResource.this.voidHandle(this.build("DELETE", requestEntity));
        }

        @Override
        public <T> T delete(Class<T> c) {
            return (T)WebResource.this.handle(c, this.build("DELETE"));
        }

        @Override
        public <T> T delete(GenericType<T> gt) {
            return (T)WebResource.this.handle(gt, this.build("DELETE"));
        }

        @Override
        public <T> T delete(Class<T> c, Object requestEntity) {
            return (T)WebResource.this.handle(c, this.build("DELETE", requestEntity));
        }

        @Override
        public <T> T delete(GenericType<T> gt, Object requestEntity) {
            return (T)WebResource.this.handle(gt, this.build("DELETE", requestEntity));
        }

        @Override
        public void method(String method) {
            WebResource.this.voidHandle(this.build(method));
        }

        @Override
        public void method(String method, Object requestEntity) {
            WebResource.this.voidHandle(this.build(method, requestEntity));
        }

        @Override
        public <T> T method(String method, Class<T> c) {
            return (T)WebResource.this.handle(c, this.build(method));
        }

        @Override
        public <T> T method(String method, GenericType<T> gt) {
            return (T)WebResource.this.handle(gt, this.build(method));
        }

        @Override
        public <T> T method(String method, Class<T> c, Object requestEntity) {
            return (T)WebResource.this.handle(c, this.build(method, requestEntity));
        }

        @Override
        public <T> T method(String method, GenericType<T> gt, Object requestEntity) {
            return (T)WebResource.this.handle(gt, this.build(method, requestEntity));
        }
    }
}

