/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.provider;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageReaderWriterProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static final Charset getCharset(MediaType m) {
        String name = m == null ? null : (String)m.getParameters().get("charset");
        return name == null ? UTF8 : Charset.forName(name);
    }

    public static final void writeTo(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] data = new byte[2048];
        while ((read = in.read(data)) != -1) {
            out.write(data, 0, read);
        }
    }

    public static final void writeTo(Reader in, Writer out) throws IOException {
        int read;
        char[] data = new char[2048];
        while ((read = in.read(data)) != -1) {
            out.write(data, 0, read);
        }
    }

    public static final String readFromAsString(InputStream in, MediaType type) throws IOException {
        int l;
        InputStreamReader reader = new InputStreamReader(in, AbstractMessageReaderWriterProvider.getCharset(type));
        StringBuilder sb = new StringBuilder();
        char[] c = new char[1024];
        while ((l = reader.read(c)) != -1) {
            sb.append(c, 0, l);
        }
        return sb.toString();
    }

    public static final void writeToAsString(String s, OutputStream out, MediaType type) throws IOException {
        BufferedWriter osw = new BufferedWriter(new OutputStreamWriter(out, AbstractMessageReaderWriterProvider.getCharset(type)));
        osw.write(s);
        ((Writer)osw).flush();
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }
}

